/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class EntityMinecartAbstract
extends VehicleEntity {
    private static final Vec3D LOWERED_PASSENGER_ATTACHMENT = new Vec3D(0.0, 0.0, 0.0);
    private static final DataWatcherObject<Integer> DATA_ID_DISPLAY_BLOCK = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_ID_DISPLAY_OFFSET = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_ID_CUSTOM_DISPLAY = DataWatcher.defineId(EntityMinecartAbstract.class, DataWatcherRegistry.BOOLEAN);
    private static final ImmutableMap<EntityPose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)EntityPose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)EntityPose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3D targetDeltaMovement = Vec3D.ZERO;
    private static final Map<BlockPropertyTrackPosition, Pair<BaseBlockPosition, BaseBlockPosition>> EXITS = SystemUtils.make(Maps.newEnumMap(BlockPropertyTrackPosition.class), enummap -> {
        BaseBlockPosition baseblockposition = EnumDirection.WEST.getNormal();
        BaseBlockPosition baseblockposition1 = EnumDirection.EAST.getNormal();
        BaseBlockPosition baseblockposition2 = EnumDirection.NORTH.getNormal();
        BaseBlockPosition baseblockposition3 = EnumDirection.SOUTH.getNormal();
        BaseBlockPosition baseblockposition4 = baseblockposition.below();
        BaseBlockPosition baseblockposition5 = baseblockposition1.below();
        BaseBlockPosition baseblockposition6 = baseblockposition2.below();
        BaseBlockPosition baseblockposition7 = baseblockposition3.below();
        enummap.put(BlockPropertyTrackPosition.NORTH_SOUTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.EAST_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.ASCENDING_EAST, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.ASCENDING_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(BlockPropertyTrackPosition.ASCENDING_NORTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(BlockPropertyTrackPosition.ASCENDING_SOUTH, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(BlockPropertyTrackPosition.SOUTH_EAST, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(BlockPropertyTrackPosition.SOUTH_WEST, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.NORTH_WEST, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(BlockPropertyTrackPosition.NORTH_EAST, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public double maxSpeed = 0.4;

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
        this.blocksBuilding = true;
    }

    protected EntityMinecartAbstract(EntityTypes<?> entitytypes, World world, double d0, double d1, double d2) {
        this(entitytypes, world);
        this.setPos(d0, d1, d2);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
    }

    public static EntityMinecartAbstract createMinecart(WorldServer worldserver, double d0, double d1, double d2, EnumMinecartType entityminecartabstract_enumminecarttype, ItemStack itemstack, @Nullable EntityHuman entityhuman) {
        EntityMinecartAbstract object1 = switch (entityminecartabstract_enumminecarttype.ordinal()) {
            case 1 -> new EntityMinecartChest(worldserver, d0, d1, d2);
            case 2 -> new EntityMinecartFurnace(worldserver, d0, d1, d2);
            case 3 -> new EntityMinecartTNT(worldserver, d0, d1, d2);
            case 4 -> new EntityMinecartMobSpawner(worldserver, d0, d1, d2);
            case 5 -> new EntityMinecartHopper(worldserver, d0, d1, d2);
            case 6 -> new EntityMinecartCommandBlock(worldserver, d0, d1, d2);
            default -> new EntityMinecartRideable(worldserver, d0, d1, d2);
        };
        EntityTypes.createDefaultStackConfig(worldserver, itemstack, entityhuman).accept(object1);
        return object1;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        datawatcher_a.define(DATA_ID_DISPLAY_OFFSET, 6);
        datawatcher_a.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return EntityBoat.canVehicleCollide(this, entity);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3D getRelativePortalPosition(EnumDirection.EnumAxis enumdirection_enumaxis, BlockUtil.Rectangle blockutil_rectangle) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle));
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity entity, EntitySize entitysize, float f2) {
        boolean flag = entity instanceof EntityVillager || entity instanceof EntityVillagerTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(entity, entitysize, f2);
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving entityliving) {
        EnumDirection enumdirection = this.getMotionDirection();
        if (enumdirection.getAxis() == EnumDirection.EnumAxis.Y) {
            return super.getDismountLocationForPassenger(entityliving);
        }
        int[][] aint = DismountUtil.offsetsForDirection(enumdirection);
        BlockPosition blockposition = this.blockPosition();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        ImmutableList<EntityPose> immutablelist = entityliving.getDismountPoses();
        for (EntityPose entitypose : immutablelist) {
            EntitySize entitysize = entityliving.getDimensions(entitypose);
            float f2 = Math.min(entitysize.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i2 = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j2 = aint.length;
                for (int k2 = 0; k2 < j2; ++k2) {
                    int[] aint2 = aint1[k2];
                    blockposition_mutableblockposition.set(blockposition.getX() + aint2[0], blockposition.getY() + i2, blockposition.getZ() + aint2[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountUtil.nonClimbableShape(this.level(), blockposition_mutableblockposition), () -> DismountUtil.nonClimbableShape(this.level(), (BlockPosition)blockposition_mutableblockposition.below()));
                    if (!DismountUtil.isBlockFloorValid(d0)) continue;
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(-f2, 0.0, -f2, f2, entitysize.height(), f2);
                    Vec3D vec3d = Vec3D.upFromBottomCenterOf(blockposition_mutableblockposition, d0);
                    if (!DismountUtil.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d))) continue;
                    entityliving.setPose(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockposition_mutableblockposition.set((double)blockposition.getX(), d1, (double)blockposition.getZ());
        for (EntityPose entitypose1 : immutablelist) {
            int l2;
            double d3;
            double d2 = entityliving.getDimensions(entitypose1).height();
            if (!(d1 + d2 <= (d3 = DismountUtil.findCeilingFrom(blockposition_mutableblockposition, l2 = MathHelper.ceil(d1 - (double)blockposition_mutableblockposition.getY() + d2), blockposition1 -> this.level().getBlockState((BlockPosition)blockposition1).getCollisionShape(this.level(), (BlockPosition)blockposition1))))) continue;
            entityliving.setPose(entitypose1);
            break;
        }
        return super.getDismountLocationForPassenger(entityliving);
    }

    @Override
    protected float getBlockSpeedFactor() {
        IBlockData iblockdata = this.level().getBlockState(this.blockPosition());
        return iblockdata.is(TagsBlock.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float f2) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<BaseBlockPosition, BaseBlockPosition> exits(BlockPropertyTrackPosition blockpropertytrackposition) {
        return EXITS.get(blockpropertytrackposition);
    }

    @Override
    public EnumDirection getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        double prevX = this.getX();
        double prevY = this.getY();
        double prevZ = this.getZ();
        float prevYaw = this.getYRot();
        float prevPitch = this.getXRot();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
        } else {
            double d2;
            this.applyGravity();
            int i2 = MathHelper.floor(this.getX());
            int j2 = MathHelper.floor(this.getY());
            int k2 = MathHelper.floor(this.getZ());
            if (this.level().getBlockState(new BlockPosition(i2, j2 - 1, k2)).is(TagsBlock.RAILS)) {
                --j2;
            }
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = this.level().getBlockState(blockposition);
            this.onRails = BlockMinecartTrackAbstract.isRail(iblockdata);
            if (this.onRails) {
                this.moveAlongTrack(blockposition, iblockdata);
                if (iblockdata.is(Blocks.ACTIVATOR_RAIL)) {
                    this.activateMinecart(i2, j2, k2, iblockdata.getValue(BlockPoweredRail.POWERED));
                }
            } else {
                this.comeOffTrack();
            }
            this.checkInsideBlocks();
            this.setXRot(0.0f);
            double d0 = this.xo - this.getX();
            double d1 = this.zo - this.getZ();
            if (d0 * d0 + d1 * d1 > 0.001) {
                this.setYRot((float)(MathHelper.atan2(d1, d0) * 180.0 / Math.PI));
                if (this.flipped) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d2 = (double)MathHelper.wrapDegrees(this.getYRot() - this.yRotO)) < -170.0 || d2 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.flipped = !this.flipped;
            }
            this.setRot(this.getYRot(), this.getXRot());
            CraftWorld bworld = this.level().getWorld();
            Location from = new Location((org.bukkit.World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
            Location to = CraftLocation.toBukkit(this.position(), (org.bukkit.World)bworld, this.getYRot(), this.getXRot());
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
            if (!from.equals((Object)to)) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
            }
            if (this.getMinecartType() == EnumMinecartType.RIDEABLE && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
                List<Entity> list = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f), IEntitySelector.pushableBy(this));
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        VehicleEntityCollisionEvent collisionEvent;
                        if (!(entity instanceof EntityHuman || entity instanceof EntityIronGolem || entity instanceof EntityMinecartAbstract || this.isVehicle() || entity.isPassenger())) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                            entity.startRiding(this);
                            continue;
                        }
                        if (!this.isPassengerOfSameVehicle(entity)) {
                            collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity.getBukkitEntity());
                            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                            if (collisionEvent.isCancelled()) continue;
                        }
                        entity.push(this);
                    }
                }
            } else {
                for (Entity entity1 : this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f))) {
                    if (this.hasPassenger(entity1) || !entity1.isPushable() || !(entity1 instanceof EntityMinecartAbstract)) continue;
                    VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent(vehicle, (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                    this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                    if (collisionEvent.isCancelled()) continue;
                    entity1.push(this);
                }
            }
            this.updateInWaterStateAndDoFluidPushing();
            if (this.isInLava()) {
                this.lavaHurt();
                this.fallDistance *= 0.5f;
            }
            this.firstTick = false;
        }
    }

    protected double getMaxSpeed() {
        return this.isInWater() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    public void activateMinecart(int i2, int j2, int k2, boolean flag) {
    }

    protected void comeOffTrack() {
        double d0 = this.getMaxSpeed();
        Vec3D vec3d = this.getDeltaMovement();
        this.setDeltaMovement(MathHelper.clamp(vec3d.x, -d0, d0), vec3d.y, MathHelper.clamp(vec3d.z, -d0, d0));
        if (this.onGround()) {
            this.setDeltaMovement(new Vec3D(this.getDeltaMovement().x * this.derailedX, this.getDeltaMovement().y * this.derailedY, this.getDeltaMovement().z * this.derailedZ));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(new Vec3D(this.getDeltaMovement().x * this.flyingX, this.getDeltaMovement().y * this.flyingY, this.getDeltaMovement().z * this.flyingZ));
        }
    }

    @Override
    public Vec3D getKnownMovement() {
        double d0 = this.getMaxSpeed();
        Vec3D vec3d = super.getKnownMovement();
        return new Vec3D(MathHelper.clamp(vec3d.x, -d0, d0), vec3d.y, MathHelper.clamp(vec3d.z, -d0, d0));
    }

    protected void moveAlongTrack(BlockPosition blockposition, IBlockData iblockdata) {
        double d18;
        Vec3D vec3d4;
        double d17;
        double d16;
        double d15;
        this.resetFallDistance();
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        Vec3D vec3d = this.getPos(d0, d1, d2);
        d1 = blockposition.getY();
        boolean flag = false;
        boolean flag1 = false;
        if (iblockdata.is(Blocks.POWERED_RAIL)) {
            flag = iblockdata.getValue(BlockPoweredRail.POWERED);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.isInWater()) {
            d3 *= 0.2;
        }
        Vec3D vec3d1 = this.getDeltaMovement();
        BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getValue(((BlockMinecartTrackAbstract)iblockdata.getBlock()).getShapeProperty());
        switch (blockpropertytrackposition) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec3d1.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec3d1.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.getDeltaMovement();
        Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.exits(blockpropertytrackposition);
        BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
        BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
        double d4 = baseblockposition1.getX() - baseblockposition.getX();
        double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.x * d4 + vec3d1.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.horizontalDistance());
        vec3d1 = new Vec3D(d8 * d4 / d6, vec3d1.y, d8 * d5 / d6);
        this.setDeltaMovement(vec3d1);
        Entity entity = this.getFirstPassenger();
        if (entity instanceof EntityHuman) {
            Vec3D vec3d2 = entity.getDeltaMovement();
            double d9 = vec3d2.horizontalDistanceSqr();
            double d10 = this.getDeltaMovement().horizontalDistanceSqr();
            if (d9 > 1.0E-4 && d10 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec3d2.x * 0.1, 0.0, vec3d2.z * 0.1));
                flag1 = false;
            }
        }
        if (flag1) {
            double d11 = this.getDeltaMovement().horizontalDistance();
            if (d11 < 0.03) {
                this.setDeltaMovement(Vec3D.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d11 = (double)blockposition.getX() + 0.5 + (double)baseblockposition.getX() * 0.5;
        double d12 = (double)blockposition.getZ() + 0.5 + (double)baseblockposition.getZ() * 0.5;
        double d13 = (double)blockposition.getX() + 0.5 + (double)baseblockposition1.getX() * 0.5;
        double d14 = (double)blockposition.getZ() + 0.5 + (double)baseblockposition1.getZ() * 0.5;
        d4 = d13 - d11;
        d5 = d14 - d12;
        if (d4 == 0.0) {
            d15 = d2 - (double)blockposition.getZ();
        } else if (d5 == 0.0) {
            d15 = d0 - (double)blockposition.getX();
        } else {
            d16 = d0 - d11;
            d17 = d2 - d12;
            d15 = (d16 * d4 + d17 * d5) * 2.0;
        }
        d0 = d11 + d4 * d15;
        d2 = d12 + d5 * d15;
        this.setPos(d0, d1, d2);
        d16 = this.isVehicle() ? 0.75 : 1.0;
        d17 = this.getMaxSpeed();
        vec3d1 = this.getDeltaMovement();
        this.move(EnumMoveType.SELF, new Vec3D(MathHelper.clamp(d16 * vec3d1.x, -d17, d17), 0.0, MathHelper.clamp(d16 * vec3d1.z, -d17, d17)));
        if (baseblockposition.getY() != 0 && MathHelper.floor(this.getX()) - blockposition.getX() == baseblockposition.getX() && MathHelper.floor(this.getZ()) - blockposition.getZ() == baseblockposition.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)baseblockposition.getY(), this.getZ());
        } else if (baseblockposition1.getY() != 0 && MathHelper.floor(this.getX()) - blockposition.getX() == baseblockposition1.getX() && MathHelper.floor(this.getZ()) - blockposition.getZ() == baseblockposition1.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)baseblockposition1.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3D vec3d3 = this.getPos(this.getX(), this.getY(), this.getZ());
        if (vec3d3 != null && vec3d != null) {
            double d19 = (vec3d.y - vec3d3.y) * 0.05;
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            if (d18 > 0.0) {
                this.setDeltaMovement(vec3d4.multiply((d18 + d19) / d18, 1.0, (d18 + d19) / d18));
            }
            this.setPos(this.getX(), vec3d3.y, this.getZ());
        }
        int i2 = MathHelper.floor(this.getX());
        int j2 = MathHelper.floor(this.getZ());
        if (i2 != blockposition.getX() || j2 != blockposition.getZ()) {
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            this.setDeltaMovement(d18 * (double)(i2 - blockposition.getX()), vec3d4.y, d18 * (double)(j2 - blockposition.getZ()));
        }
        if (flag) {
            vec3d4 = this.getDeltaMovement();
            d18 = vec3d4.horizontalDistance();
            if (d18 > 0.01) {
                double d20 = 0.06;
                this.setDeltaMovement(vec3d4.add(vec3d4.x / d18 * 0.06, 0.0, vec3d4.z / d18 * 0.06));
            } else {
                Vec3D vec3d5 = this.getDeltaMovement();
                double d21 = vec3d5.x;
                double d22 = vec3d5.z;
                if (blockpropertytrackposition == BlockPropertyTrackPosition.EAST_WEST) {
                    if (this.isRedstoneConductor(blockposition.west())) {
                        d21 = 0.02;
                    } else if (this.isRedstoneConductor(blockposition.east())) {
                        d21 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != BlockPropertyTrackPosition.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isRedstoneConductor(blockposition.north())) {
                        d22 = 0.02;
                    } else if (this.isRedstoneConductor(blockposition.south())) {
                        d22 = -0.02;
                    }
                }
                this.setDeltaMovement(d21, vec3d5.y, d22);
            }
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    private boolean isRedstoneConductor(BlockPosition blockposition) {
        return this.level().getBlockState(blockposition).isRedstoneConductor(this.level(), blockposition);
    }

    protected void applyNaturalSlowdown() {
        double d0 = this.isVehicle() || !this.slowWhenEmpty ? 0.997 : 0.96;
        Vec3D vec3d = this.getDeltaMovement();
        vec3d = vec3d.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3d = vec3d.scale(0.95f);
        }
        this.setDeltaMovement(vec3d);
    }

    @Nullable
    public Vec3D getPosOffs(double d0, double d1, double d2, double d3) {
        IBlockData iblockdata;
        int i2 = MathHelper.floor(d0);
        int j2 = MathHelper.floor(d1);
        int k2 = MathHelper.floor(d2);
        if (this.level().getBlockState(new BlockPosition(i2, j2 - 1, k2)).is(TagsBlock.RAILS)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.isRail(iblockdata = this.level().getBlockState(new BlockPosition(i2, j2, k2)))) {
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getValue(((BlockMinecartTrackAbstract)iblockdata.getBlock()).getShapeProperty());
            d1 = j2;
            if (blockpropertytrackposition.isAscending()) {
                d1 = j2 + 1;
            }
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.exits(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d4 = baseblockposition1.getX() - baseblockposition.getX();
            double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.getY() != 0 && MathHelper.floor(d0 += (d4 /= d6) * d3) - i2 == baseblockposition.getX() && MathHelper.floor(d2 += (d5 /= d6) * d3) - k2 == baseblockposition.getZ()) {
                d1 += (double)baseblockposition.getY();
            } else if (baseblockposition1.getY() != 0 && MathHelper.floor(d0) - i2 == baseblockposition1.getX() && MathHelper.floor(d2) - k2 == baseblockposition1.getZ()) {
                d1 += (double)baseblockposition1.getY();
            }
            return this.getPos(d0, d1, d2);
        }
        return null;
    }

    @Nullable
    public Vec3D getPos(double d0, double d1, double d2) {
        IBlockData iblockdata;
        int i2 = MathHelper.floor(d0);
        int j2 = MathHelper.floor(d1);
        int k2 = MathHelper.floor(d2);
        if (this.level().getBlockState(new BlockPosition(i2, j2 - 1, k2)).is(TagsBlock.RAILS)) {
            --j2;
        }
        if (BlockMinecartTrackAbstract.isRail(iblockdata = this.level().getBlockState(new BlockPosition(i2, j2, k2)))) {
            double d12;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getValue(((BlockMinecartTrackAbstract)iblockdata.getBlock()).getShapeProperty());
            Pair<BaseBlockPosition, BaseBlockPosition> pair = EntityMinecartAbstract.exits(blockpropertytrackposition);
            BaseBlockPosition baseblockposition = (BaseBlockPosition)pair.getFirst();
            BaseBlockPosition baseblockposition1 = (BaseBlockPosition)pair.getSecond();
            double d3 = (double)i2 + 0.5 + (double)baseblockposition.getX() * 0.5;
            double d4 = (double)j2 + 0.0625 + (double)baseblockposition.getY() * 0.5;
            double d5 = (double)k2 + 0.5 + (double)baseblockposition.getZ() * 0.5;
            double d6 = (double)i2 + 0.5 + (double)baseblockposition1.getX() * 0.5;
            double d7 = (double)j2 + 0.0625 + (double)baseblockposition1.getY() * 0.5;
            double d8 = (double)k2 + 0.5 + (double)baseblockposition1.getZ() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = d2 - (double)k2;
            } else if (d11 == 0.0) {
                d12 = d0 - (double)i2;
            } else {
                double d13 = d0 - d3;
                double d14 = d2 - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            d0 = d3 + d9 * d12;
            d1 = d4 + d10 * d12;
            d2 = d5 + d11 * d12;
            if (d10 < 0.0) {
                d1 += 1.0;
            } else if (d10 > 0.0) {
                d1 += 0.5;
            }
            return new Vec3D(d0, d1, d2);
        }
        return null;
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        return this.hasCustomDisplay() ? axisalignedbb.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), nbttagcompound.getCompound("DisplayState")));
            this.setDisplayOffset(nbttagcompound.getInt("DisplayOffset"));
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (this.hasCustomDisplay()) {
            nbttagcompound.putBoolean("CustomDisplayTile", true);
            nbttagcompound.put("DisplayState", GameProfileSerializer.writeBlockState(this.getDisplayBlockState()));
            nbttagcompound.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    @Override
    public void push(Entity entity) {
        if (!(this.level().isClientSide || entity.noPhysics || this.noPhysics || this.hasPassenger(entity))) {
            double d1;
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
            if (collisionEvent.isCancelled()) {
                return;
            }
            double d0 = entity.getX() - this.getX();
            double d2 = d0 * d0 + (d1 = entity.getZ() - this.getZ()) * d1;
            if (d2 >= (double)1.0E-4f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.5;
                d1 *= 0.5;
                if (entity instanceof EntityMinecartAbstract) {
                    Vec3D vec3d1;
                    double d5;
                    double d4 = entity.getX() - this.getX();
                    Vec3D vec3d = new Vec3D(d4, 0.0, d5 = entity.getZ() - this.getZ()).normalize();
                    double d6 = Math.abs(vec3d.dot(vec3d1 = new Vec3D(MathHelper.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, MathHelper.sin(this.getYRot() * ((float)Math.PI / 180))).normalize()));
                    if (d6 < (double)0.8f) {
                        return;
                    }
                    Vec3D vec3d2 = this.getDeltaMovement();
                    Vec3D vec3d3 = entity.getDeltaMovement();
                    if (((EntityMinecartAbstract)entity).getMinecartType() == EnumMinecartType.FURNACE && this.getMinecartType() != EnumMinecartType.FURNACE) {
                        this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                        this.push(vec3d3.x - d0, 0.0, vec3d3.z - d1);
                        entity.setDeltaMovement(vec3d3.multiply(0.95, 1.0, 0.95));
                    } else if (((EntityMinecartAbstract)entity).getMinecartType() != EnumMinecartType.FURNACE && this.getMinecartType() == EnumMinecartType.FURNACE) {
                        entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                        entity.push(vec3d2.x + d0, 0.0, vec3d2.z + d1);
                        this.setDeltaMovement(vec3d2.multiply(0.95, 1.0, 0.95));
                    } else {
                        double d7 = (vec3d3.x + vec3d2.x) / 2.0;
                        double d8 = (vec3d3.z + vec3d2.z) / 2.0;
                        this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                        this.push(d7 - d0, 0.0, d8 - d1);
                        entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                        entity.push(d7 + d0, 0.0, d8 + d1);
                    }
                } else {
                    this.push(-d0, 0.0, -d1);
                    entity.push(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    @Override
    public void lerpTo(double d0, double d1, double d2, float f2, float f1, int i2) {
        this.lerpX = d0;
        this.lerpY = d1;
        this.lerpZ = d2;
        this.lerpYRot = f2;
        this.lerpXRot = f1;
        this.lerpSteps = i2 + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpMotion(double d0, double d1, double d2) {
        this.targetDeltaMovement = new Vec3D(d0, d1, d2);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public abstract EnumMinecartType getMinecartType();

    public IBlockData getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public IBlockData getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(IBlockData iblockdata) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(iblockdata));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int i2) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, i2);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean flag) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, flag);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(switch (this.getMinecartType().ordinal()) {
            case 1 -> Items.CHEST_MINECART;
            case 2 -> Items.FURNACE_MINECART;
            case 3 -> Items.TNT_MINECART;
            default -> Items.MINECART;
            case 5 -> Items.HOPPER_MINECART;
            case 6 -> Items.COMMAND_BLOCK_MINECART;
        });
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public static enum EnumMinecartType {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

