/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityMinecartContainer
extends EntityMinecartAbstract
implements ContainerEntity {
    private NonNullList<ItemStack> itemStacks;
    @Nullable
    public ResourceKey<LootTable> lootTable;
    public long lootTableSeed;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        CraftEntity cart = this.getBukkitEntity();
        if (cart instanceof InventoryHolder) {
            return (InventoryHolder)cart;
        }
        return null;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.getBukkitEntity().getLocation();
    }

    protected EntityMinecartContainer(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }

    protected EntityMinecartContainer(EntityTypes<?> entitytypes, double d0, double d1, double d2, World world) {
        super(entitytypes, world, d0, d1, d2);
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }

    @Override
    public void destroy(DamageSource damagesource) {
        super.destroy(damagesource);
        this.chestVehicleDestroyed(damagesource, this.level(), this);
    }

    @Override
    public ItemStack getItem(int i2) {
        return this.getChestVehicleItem(i2);
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        return this.removeChestVehicleItem(i2, j2);
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        return this.removeChestVehicleItemNoUpdate(i2);
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        this.setChestVehicleItem(i2, itemstack);
    }

    @Override
    public SlotAccess getSlot(int i2) {
        return this.getChestVehicleSlot(i2);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.isChestVehicleStillValid(entityhuman);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        if (!this.level().isClientSide && entity_removalreason.shouldDestroy()) {
            InventoryUtils.dropContents(this.level(), this, (IInventory)this);
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        this.addChestVehicleSaveData(nbttagcompound, this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        super.readAdditionalSaveData(nbttagcompound);
        this.readChestVehicleSaveData(nbttagcompound, this.registryAccess());
    }

    @Override
    public EnumInteractionResult interact(EntityHuman entityhuman, EnumHand enumhand) {
        return this.interactWithContainerVehicle(entityhuman);
    }

    @Override
    protected void applyNaturalSlowdown() {
        float f2 = 0.98f;
        if (this.lootTable == null) {
            int i2 = 15 - Container.getRedstoneSignalFromContainer(this);
            f2 += (float)i2 * 0.001f;
        }
        if (this.isInWater()) {
            f2 *= 0.95f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(f2, 0.0, f2));
    }

    @Override
    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public void setLootTable(ResourceKey<LootTable> resourcekey, long i2) {
        this.lootTable = resourcekey;
        this.lootTableSeed = i2;
    }

    @Override
    @Nullable
    public Container createMenu(int i2, PlayerInventory playerinventory, EntityHuman entityhuman) {
        if (this.lootTable != null && entityhuman.isSpectator()) {
            return null;
        }
        this.unpackChestVehicleLootTable(playerinventory.player);
        return this.createMenu(i2, playerinventory);
    }

    protected abstract Container createMenu(int var1, PlayerInventory var2);

    @Override
    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable ResourceKey<LootTable> resourcekey) {
        this.lootTable = resourcekey;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long i2) {
        this.lootTableSeed = i2;
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }
}

