/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final DataWatcherObject<Integer> DATA_ID_HURT = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Integer> DATA_ID_HURTDIR = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.INT);
    protected static final DataWatcherObject<Float> DATA_ID_DAMAGE = DataWatcher.defineId(VehicleEntity.class, DataWatcherRegistry.FLOAT);

    public VehicleEntity(EntityTypes<?> entitytypes, World world) {
        super(entitytypes, world);
    }

    @Override
    public boolean hurt(DamageSource damagesource, float f2) {
        if (!this.level().isClientSide && !this.isRemoved()) {
            boolean flag;
            if (this.isInvulnerableTo(damagesource)) {
                return false;
            }
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity attacker = damagesource.getEntity() == null ? null : damagesource.getEntity().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)f2);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            f2 = (float)event.getDamage();
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(this.getDamage() + f2 * 10.0f);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
            boolean bl = flag = damagesource.getEntity() instanceof EntityHuman && ((EntityHuman)damagesource.getEntity()).getAbilities().instabuild;
            if ((flag || this.getDamage() <= 40.0f) && !this.shouldSourceDestroy(damagesource)) {
                if (flag) {
                    VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                    if (destroyEvent.isCancelled()) {
                        this.setDamage(40.0f);
                        return true;
                    }
                    this.discard(EntityRemoveEvent.Cause.DEATH);
                }
            } else {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.setDamage(40.0f);
                    return true;
                }
                this.destroy(damagesource);
            }
            return true;
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource damagesource) {
        return false;
    }

    public void destroy(Item item) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = new ItemStack(item);
            itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
            this.spawnAtLocation(itemstack);
        }
    }

    @Override
    protected void defineSynchedData(DataWatcher.a datawatcher_a) {
        datawatcher_a.define(DATA_ID_HURT, 0);
        datawatcher_a.define(DATA_ID_HURTDIR, 1);
        datawatcher_a.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int i2) {
        this.entityData.set(DATA_ID_HURT, i2);
    }

    public void setHurtDir(int i2) {
        this.entityData.set(DATA_ID_HURTDIR, i2);
    }

    public void setDamage(float f2) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(f2));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource damagesource) {
        this.destroy(this.getDropItem());
    }

    abstract Item getDropItem();
}

