/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodConstants;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class FoodMetaData {
    public int foodLevel = 20;
    public float saturationLevel = 5.0f;
    public float exhaustionLevel;
    private int tickTimer;
    private EntityHuman entityhuman;
    public int saturatedRegenRate = 10;
    public int unsaturatedRegenRate = 80;
    public int starvationRate = 80;
    private int lastFoodLevel = 20;

    public FoodMetaData() {
        throw new AssertionError((Object)"Whoopsie, we missed the bukkit.");
    }

    public FoodMetaData(EntityHuman entityhuman) {
        Validate.notNull((Object)entityhuman);
        this.entityhuman = entityhuman;
    }

    private void add(int i2, float f2) {
        this.foodLevel = MathHelper.clamp(i2 + this.foodLevel, 0, 20);
        this.saturationLevel = MathHelper.clamp(f2 + this.saturationLevel, 0.0f, (float)this.foodLevel);
    }

    public void eat(int i2, float f2) {
        this.add(i2, FoodConstants.saturationByModifier(i2, f2));
    }

    public void eat(FoodInfo foodinfo) {
        this.add(foodinfo.nutrition(), foodinfo.saturation());
    }

    public void eat(ItemStack itemstack, FoodInfo foodinfo) {
        int oldFoodLevel = this.foodLevel;
        FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(this.entityhuman, foodinfo.nutrition() + oldFoodLevel, itemstack);
        if (!event.isCancelled()) {
            this.add(event.getFoodLevel() - oldFoodLevel, foodinfo.saturation());
        }
        ((EntityPlayer)this.entityhuman).getBukkitEntity().sendHealthUpdate();
    }

    public void tick(EntityHuman entityhuman) {
        boolean flag;
        EnumDifficulty enumdifficulty = entityhuman.level().getDifficulty();
        this.lastFoodLevel = this.foodLevel;
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (enumdifficulty != EnumDifficulty.PEACEFUL) {
                FoodLevelChangeEvent event = CraftEventFactory.callFoodLevelChangeEvent(entityhuman, Math.max(this.foodLevel - 1, 0));
                if (!event.isCancelled()) {
                    this.foodLevel = event.getFoodLevel();
                }
                ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutUpdateHealth(((EntityPlayer)entityhuman).getBukkitEntity().getScaledHealth(), this.foodLevel, this.saturationLevel));
            }
        }
        if ((flag = entityhuman.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.saturationLevel > 0.0f && entityhuman.isHurt() && this.foodLevel >= 20) {
            ++this.tickTimer;
            if (this.tickTimer >= this.saturatedRegenRate) {
                float f2 = Math.min(this.saturationLevel, 6.0f);
                entityhuman.heal(f2 / 6.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                entityhuman.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.tickTimer = 0;
            }
        } else if (flag && this.foodLevel >= 18 && entityhuman.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= this.unsaturatedRegenRate) {
                entityhuman.heal(1.0f, EntityRegainHealthEvent.RegainReason.SATIATED);
                entityhuman.causeFoodExhaustion(entityhuman.level().spigotConfig.regenExhaustion, EntityExhaustionEvent.ExhaustionReason.REGEN);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= this.starvationRate) {
                if (entityhuman.getHealth() > 10.0f || enumdifficulty == EnumDifficulty.HARD || entityhuman.getHealth() > 1.0f && enumdifficulty == EnumDifficulty.NORMAL) {
                    entityhuman.hurt(entityhuman.damageSources().starve(), 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }

    public void readAdditionalSaveData(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.contains("foodLevel", 99)) {
            this.foodLevel = nbttagcompound.getInt("foodLevel");
            this.tickTimer = nbttagcompound.getInt("foodTickTimer");
            this.saturationLevel = nbttagcompound.getFloat("foodSaturationLevel");
            this.exhaustionLevel = nbttagcompound.getFloat("foodExhaustionLevel");
        }
    }

    public void addAdditionalSaveData(NBTTagCompound nbttagcompound) {
        nbttagcompound.putInt("foodLevel", this.foodLevel);
        nbttagcompound.putInt("foodTickTimer", this.tickTimer);
        nbttagcompound.putFloat("foodSaturationLevel", this.saturationLevel);
        nbttagcompound.putFloat("foodExhaustionLevel", this.exhaustionLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public int getLastFoodLevel() {
        return this.lastFoodLevel;
    }

    public boolean needsFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float f2) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + f2, 40.0f);
    }

    public float getExhaustionLevel() {
        return this.exhaustionLevel;
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public void setFoodLevel(int i2) {
        this.foodLevel = i2;
    }

    public void setSaturation(float f2) {
        this.saturationLevel = f2;
    }

    public void setExhaustion(float f2) {
        this.exhaustionLevel = f2;
    }
}

