/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public NonNullList<net.minecraft.world.item.ItemStack> lastSlots = NonNullList.create();
    public NonNullList<Slot> slots = NonNullList.create();
    private final List<ContainerProperty> dataSlots = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack carried = net.minecraft.world.item.ItemStack.EMPTY;
    public NonNullList<net.minecraft.world.item.ItemStack> remoteSlots = NonNullList.create();
    private final IntList remoteDataSlots = new IntArrayList();
    private net.minecraft.world.item.ItemStack remoteCarried = net.minecraft.world.item.ItemStack.EMPTY;
    private int stateId;
    @Nullable
    private final Containers<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ICrafting> containerListeners = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;
    public boolean checkReachable = true;
    private IChatBaseComponent title;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title not set");
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    protected Container(@Nullable Containers<?> containers, int i2) {
        this.menuType = containers;
        this.containerId = i2;
    }

    protected static boolean stillValid(ContainerAccess containeraccess, EntityHuman entityhuman, Block block) {
        return containeraccess.evaluate((world, blockposition) -> !world.getBlockState((BlockPosition)blockposition).is(block) ? false : entityhuman.canInteractWithBlock((BlockPosition)blockposition, 4.0), true);
    }

    public Containers<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(IInventory iinventory, int i2) {
        int j2 = iinventory.getContainerSize();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container size " + j2 + " is smaller than expected " + i2);
        }
    }

    protected static void checkContainerDataCount(IContainerProperties icontainerproperties, int i2) {
        int j2 = icontainerproperties.getCount();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container data count " + j2 + " is smaller than expected " + i2);
        }
    }

    public boolean isValidSlotIndex(int i2) {
        return i2 == -1 || i2 == -999 || i2 < this.slots.size();
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.slots.size();
        this.slots.add(slot);
        this.lastSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        this.remoteSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        return slot;
    }

    protected ContainerProperty addDataSlot(ContainerProperty containerproperty) {
        this.dataSlots.add(containerproperty);
        this.remoteDataSlots.add(0);
        return containerproperty;
    }

    protected void addDataSlots(IContainerProperties icontainerproperties) {
        for (int i2 = 0; i2 < icontainerproperties.getCount(); ++i2) {
            this.addDataSlot(ContainerProperty.forContainer(icontainerproperties, i2));
        }
    }

    public void addSlotListener(ICrafting icrafting) {
        if (!this.containerListeners.contains(icrafting)) {
            this.containerListeners.add(icrafting);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(ContainerSynchronizer containersynchronizer) {
        this.synchronizer = containersynchronizer;
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        int i2;
        int j2 = this.slots.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.remoteSlots.set(i2, this.slots.get(i2).getItem().copy());
        }
        this.remoteCarried = this.getCarried().copy();
        j2 = this.dataSlots.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.remoteDataSlots.set(i2, this.dataSlots.get(i2).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, this.remoteSlots, this.remoteCarried, this.remoteDataSlots.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        this.remoteCarried = this.getCarried().copy();
        if (this.synchronizer != null) {
            this.synchronizer.sendCarriedChange(this, this.remoteCarried);
        }
    }

    public void removeSlotListener(ICrafting icrafting) {
        this.containerListeners.remove(icrafting);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.create();
        for (Slot slot : this.slots) {
            nonnulllist.add(slot.getItem());
        }
        return nonnulllist;
    }

    public void broadcastChanges() {
        int i2;
        for (i2 = 0; i2 < this.slots.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i2).getItem();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::copy);
            this.triggerSlotListeners(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.synchronizeSlotToRemote(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (i2 = 0; i2 < this.dataSlots.size(); ++i2) {
            ContainerProperty containerproperty = this.dataSlots.get(i2);
            int j2 = containerproperty.get();
            if (containerproperty.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(i2, j2);
            }
            this.synchronizeDataSlotToRemote(i2, j2);
        }
    }

    public void broadcastFullState() {
        int i2;
        for (i2 = 0; i2 < this.slots.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i2).getItem();
            Objects.requireNonNull(itemstack);
            this.triggerSlotListeners(i2, itemstack, itemstack::copy);
        }
        for (i2 = 0; i2 < this.dataSlots.size(); ++i2) {
            ContainerProperty containerproperty = this.dataSlots.get(i2);
            if (!containerproperty.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(i2, containerproperty.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int i2, int j2) {
        for (ICrafting icrafting : this.containerListeners) {
            icrafting.dataChanged(this, i2, j2);
        }
    }

    private void triggerSlotListeners(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.lastSlots.get(i2);
        if (!net.minecraft.world.item.ItemStack.matches(itemstack1, itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.lastSlots.set(i2, itemstack2);
            for (ICrafting icrafting : this.containerListeners) {
                icrafting.slotChanged(this, i2, itemstack2);
            }
        }
    }

    private void synchronizeSlotToRemote(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1;
        if (!this.suppressRemoteUpdates && !net.minecraft.world.item.ItemStack.matches(itemstack1 = this.remoteSlots.get(i2), itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.remoteSlots.set(i2, itemstack2);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, i2, itemstack2);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int i2, int j2) {
        int k2;
        if (!this.suppressRemoteUpdates && (k2 = this.remoteDataSlots.getInt(i2)) != j2) {
            this.remoteDataSlots.set(i2, j2);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, i2, j2);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (!this.suppressRemoteUpdates && !net.minecraft.world.item.ItemStack.matches(this.getCarried(), this.remoteCarried)) {
            this.remoteCarried = this.getCarried().copy();
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, this.remoteCarried);
            }
        }
    }

    public void setRemoteSlot(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.remoteSlots.set(i2, itemstack.copy());
    }

    public void setRemoteSlotNoCopy(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 >= 0 && i2 < this.remoteSlots.size()) {
            this.remoteSlots.set(i2, itemstack);
        } else {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)i2, (Object)this.remoteSlots.size());
        }
    }

    public void setRemoteCarried(net.minecraft.world.item.ItemStack itemstack) {
        this.remoteCarried = itemstack.copy();
    }

    public boolean clickMenuButton(EntityHuman entityhuman, int i2) {
        return false;
    }

    public Slot getSlot(int i2) {
        return this.slots.get(i2);
    }

    public abstract net.minecraft.world.item.ItemStack quickMoveStack(EntityHuman var1, int var2);

    public void clicked(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        try {
            this.doClick(i2, j2, inventoryclicktype, entityhuman);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Container click");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Click info");
            crashreportsystemdetails.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            crashreportsystemdetails.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.setDetail("Slot Count", this.slots.size());
            crashreportsystemdetails.setDetail("Slot", i2);
            crashreportsystemdetails.setDetail("Button", j2);
            crashreportsystemdetails.setDetail("Type", (Object)inventoryclicktype);
            throw new ReportedException(crashreport);
        }
    }

    private void doClick(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        block43: {
            block55: {
                block51: {
                    net.minecraft.world.item.ItemStack itemstack;
                    Slot slot;
                    net.minecraft.world.item.ItemStack itemstack42;
                    PlayerInventory playerinventory;
                    block54: {
                        block53: {
                            block52: {
                                block48: {
                                    ClickAction clickaction;
                                    block50: {
                                        block49: {
                                            block47: {
                                                block41: {
                                                    block46: {
                                                        net.minecraft.world.item.ItemStack itemstack2;
                                                        block45: {
                                                            block44: {
                                                                block42: {
                                                                    playerinventory = entityhuman.getInventory();
                                                                    if (inventoryclicktype != InventoryClickType.QUICK_CRAFT) break block41;
                                                                    int i1 = this.quickcraftStatus;
                                                                    this.quickcraftStatus = Container.getQuickcraftHeader(j2);
                                                                    if (i1 == 1 && this.quickcraftStatus == 2 || i1 == this.quickcraftStatus) break block42;
                                                                    this.resetQuickCraft();
                                                                    break block43;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block44;
                                                                this.resetQuickCraft();
                                                                break block43;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block45;
                                                            this.quickcraftType = Container.getQuickcraftType(j2);
                                                            if (Container.isValidQuickcraftType(this.quickcraftType, entityhuman)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block43;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block46;
                                                        Slot slot2 = this.slots.get(i2);
                                                        if (!Container.canItemQuickReplace(slot2, itemstack2 = this.getCarried(), true) || !slot2.mayPlace(itemstack2) || this.quickcraftType != 2 && itemstack2.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot2)) break block43;
                                                        this.quickcraftSlots.add(slot2);
                                                        break block43;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack1 = this.getCarried().copy();
                                                            if (itemstack1.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int l2 = this.getCarried().getCount();
                                                            Iterator<Slot> iterator = this.quickcraftSlots.iterator();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            while (iterator.hasNext()) {
                                                                Slot slot1 = iterator.next();
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.getCarried();
                                                                if (slot1 == null || !Container.canItemQuickReplace(slot1, itemstack2, true) || !slot1.mayPlace(itemstack2) || this.quickcraftType != 2 && itemstack2.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                                int j1 = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                                int k1 = Math.min(itemstack1.getMaxStackSize(), slot1.getMaxStackSize(itemstack1));
                                                                int l1 = Math.min(Container.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, itemstack1) + j1, k1);
                                                                l2 -= l1 - j1;
                                                                draggedSlots.put(slot1.index, itemstack1.copyWithCount(l1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack1);
                                                            newcursor.setAmount(l2);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.getCarried();
                                                            this.setCarried(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.quickcraftType == 1, eventmap);
                                                            entityhuman.level().getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.getCarried() != null) {
                                                                    this.setCarried(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.setCarried(oldCursor);
                                                            }
                                                            if (needsUpdate && entityhuman instanceof EntityPlayer) {
                                                                this.sendAllDataToRemote();
                                                            }
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block43;
                                                }
                                                if (this.quickcraftStatus == 0) break block47;
                                                this.resetQuickCraft();
                                                break block43;
                                            }
                                            if (inventoryclicktype != InventoryClickType.PICKUP && inventoryclicktype != InventoryClickType.QUICK_MOVE || j2 != 0 && j2 != 1) break block48;
                                            ClickAction clickAction = clickaction = j2 == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (i2 != -999) break block49;
                                            if (this.getCarried().isEmpty()) break block43;
                                            if (clickaction == ClickAction.PRIMARY) {
                                                net.minecraft.world.item.ItemStack carried = this.getCarried();
                                                this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
                                                entityhuman.drop(carried, true);
                                            } else {
                                                entityhuman.drop(this.getCarried().split(1), true);
                                            }
                                            break block43;
                                        }
                                        if (inventoryclicktype != InventoryClickType.QUICK_MOVE) break block50;
                                        if (i2 < 0) {
                                            return;
                                        }
                                        Slot slot3 = this.slots.get(i2);
                                        if (!slot3.mayPickup(entityhuman)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.quickMoveStack(entityhuman, i2);
                                        while (!itemstack3.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot3.getItem(), itemstack3)) {
                                            itemstack3 = this.quickMoveStack(entityhuman, i2);
                                        }
                                        break block43;
                                    }
                                    if (i2 < 0) {
                                        return;
                                    }
                                    Slot slot4 = this.slots.get(i2);
                                    net.minecraft.world.item.ItemStack itemstack5 = slot4.getItem();
                                    net.minecraft.world.item.ItemStack itemstack3 = this.getCarried();
                                    entityhuman.updateTutorialInventoryAction(itemstack3, slot4.getItem(), clickaction);
                                    if (!this.tryItemClickBehaviourOverride(entityhuman, clickaction, slot4, itemstack5, itemstack3)) {
                                        if (itemstack5.isEmpty()) {
                                            if (!itemstack3.isEmpty()) {
                                                int i22 = clickaction == ClickAction.PRIMARY ? itemstack3.getCount() : 1;
                                                this.setCarried(slot4.safeInsert(itemstack3, i22));
                                            }
                                        } else if (slot4.mayPickup(entityhuman)) {
                                            if (itemstack3.isEmpty()) {
                                                int i23 = clickaction == ClickAction.PRIMARY ? itemstack5.getCount() : (itemstack5.getCount() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot4.tryRemove(i23, Integer.MAX_VALUE, entityhuman);
                                                optional.ifPresent(itemstack4 -> {
                                                    this.setCarried((net.minecraft.world.item.ItemStack)itemstack4);
                                                    slot4.onTake(entityhuman, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            } else if (slot4.mayPlace(itemstack3)) {
                                                if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack5, itemstack3)) {
                                                    int i24 = clickaction == ClickAction.PRIMARY ? itemstack3.getCount() : 1;
                                                    this.setCarried(slot4.safeInsert(itemstack3, i24));
                                                } else if (itemstack3.getCount() <= slot4.getMaxStackSize(itemstack3)) {
                                                    this.setCarried(itemstack5);
                                                    slot4.setByPlayer(itemstack3);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack5, itemstack3)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot4.tryRemove(itemstack5.getCount(), itemstack3.getMaxStackSize() - itemstack3.getCount(), entityhuman);
                                                optional1.ifPresent(itemstack4 -> {
                                                    itemstack3.grow(itemstack4.getCount());
                                                    slot4.onTake(entityhuman, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            }
                                        }
                                    }
                                    slot4.setChanged();
                                    if (!(entityhuman instanceof EntityPlayer) || slot4.getMaxStackSize() == 64) break block43;
                                    ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutSetSlot(this.containerId, this.incrementStateId(), slot4.index, slot4.getItem()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutSetSlot(this.containerId, this.incrementStateId(), 0, this.getSlot(0).getItem()));
                                    }
                                    break block43;
                                }
                                if (inventoryclicktype != InventoryClickType.SWAP || (j2 < 0 || j2 >= 9) && j2 != 40) break block51;
                                itemstack42 = playerinventory.getItem(j2);
                                slot = this.slots.get(i2);
                                itemstack = slot.getItem();
                                if (itemstack42.isEmpty() && itemstack.isEmpty()) break block43;
                                if (!itemstack42.isEmpty()) break block52;
                                if (!slot.mayPickup(entityhuman)) break block43;
                                playerinventory.setItem(j2, itemstack);
                                slot.onSwapCraft(itemstack.getCount());
                                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
                                slot.onTake(entityhuman, itemstack);
                                break block43;
                            }
                            if (!itemstack.isEmpty()) break block53;
                            if (!slot.mayPlace(itemstack42)) break block43;
                            int j22 = slot.getMaxStackSize(itemstack42);
                            if (itemstack42.getCount() > j22) {
                                slot.setByPlayer(itemstack42.split(j22));
                            } else {
                                playerinventory.setItem(j2, net.minecraft.world.item.ItemStack.EMPTY);
                                slot.setByPlayer(itemstack42);
                            }
                            break block43;
                        }
                        if (!slot.mayPickup(entityhuman) || !slot.mayPlace(itemstack42)) break block43;
                        int j23 = slot.getMaxStackSize(itemstack42);
                        if (itemstack42.getCount() <= j23) break block54;
                        slot.setByPlayer(itemstack42.split(j23));
                        slot.onTake(entityhuman, itemstack);
                        if (playerinventory.add(itemstack)) break block43;
                        entityhuman.drop(itemstack, true);
                        break block43;
                    }
                    playerinventory.setItem(j2, itemstack);
                    slot.setByPlayer(itemstack42);
                    slot.onTake(entityhuman, itemstack);
                    break block43;
                }
                if (inventoryclicktype != InventoryClickType.CLONE || !entityhuman.hasInfiniteMaterials() || !this.getCarried().isEmpty() || i2 < 0) break block55;
                Slot slot2 = this.slots.get(i2);
                if (!slot2.hasItem()) break block43;
                net.minecraft.world.item.ItemStack itemstack1 = slot2.getItem();
                this.setCarried(itemstack1.copyWithCount(itemstack1.getMaxStackSize()));
                break block43;
            }
            if (inventoryclicktype == InventoryClickType.THROW && this.getCarried().isEmpty() && i2 >= 0) {
                Slot slot2 = this.slots.get(i2);
                int k2 = j2 == 0 ? 1 : slot2.getItem().getCount();
                net.minecraft.world.item.ItemStack itemstack = slot2.safeTake(k2, Integer.MAX_VALUE, entityhuman);
                entityhuman.drop(itemstack, true);
            } else if (inventoryclicktype == InventoryClickType.PICKUP_ALL && i2 >= 0) {
                Slot slot2 = this.slots.get(i2);
                net.minecraft.world.item.ItemStack itemstack1 = this.getCarried();
                if (!(itemstack1.isEmpty() || slot2.hasItem() && slot2.mayPickup(entityhuman))) {
                    int l3 = j2 == 0 ? 0 : this.slots.size() - 1;
                    int j24 = j2 == 0 ? 1 : -1;
                    for (int i25 = 0; i25 < 2; ++i25) {
                        for (int k2 = l3; k2 >= 0 && k2 < this.slots.size() && itemstack1.getCount() < itemstack1.getMaxStackSize(); k2 += j24) {
                            Slot slot3 = this.slots.get(k2);
                            if (!slot3.hasItem() || !Container.canItemQuickReplace(slot3, itemstack1, true) || !slot3.mayPickup(entityhuman) || !this.canTakeItemForPickAll(itemstack1, slot3)) continue;
                            net.minecraft.world.item.ItemStack itemstack5 = slot3.getItem();
                            if (i25 == 0 && itemstack5.getCount() == itemstack5.getMaxStackSize()) continue;
                            net.minecraft.world.item.ItemStack itemstack6 = slot3.safeTake(itemstack5.getCount(), itemstack1.getMaxStackSize() - itemstack1.getCount(), entityhuman);
                            itemstack1.grow(itemstack6.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean tryItemClickBehaviourOverride(EntityHuman entityhuman, ClickAction clickaction, Slot slot, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        FeatureFlagSet featureflagset = entityhuman.level().enabledFeatures();
        return itemstack1.isItemEnabled(featureflagset) && itemstack1.overrideStackedOnOther(slot, clickaction, entityhuman) ? true : itemstack.isItemEnabled(featureflagset) && itemstack.overrideOtherStackedOnMe(itemstack1, slot, clickaction, entityhuman, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack get() {
                return Container.this.getCarried();
            }

            @Override
            public boolean set(net.minecraft.world.item.ItemStack itemstack) {
                Container.this.setCarried(itemstack);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(net.minecraft.world.item.ItemStack itemstack, Slot slot) {
        return true;
    }

    public void removed(EntityHuman entityhuman) {
        net.minecraft.world.item.ItemStack itemstack;
        if (entityhuman instanceof EntityPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
            if (entityhuman.isAlive() && !((EntityPlayer)entityhuman).hasDisconnected()) {
                entityhuman.getInventory().placeItemBackInInventory(itemstack);
            } else {
                entityhuman.drop(itemstack, false);
            }
        }
    }

    protected void clearContainer(EntityHuman entityhuman, IInventory iinventory) {
        if (!(!entityhuman.isAlive() || entityhuman instanceof EntityPlayer && ((EntityPlayer)entityhuman).hasDisconnected())) {
            for (int i2 = 0; i2 < iinventory.getContainerSize(); ++i2) {
                PlayerInventory playerinventory = entityhuman.getInventory();
                if (!(playerinventory.player instanceof EntityPlayer)) continue;
                playerinventory.placeItemBackInInventory(iinventory.removeItemNoUpdate(i2));
            }
        } else {
            for (int i3 = 0; i3 < iinventory.getContainerSize(); ++i3) {
                entityhuman.drop(iinventory.removeItemNoUpdate(i3), false);
            }
        }
    }

    public void slotsChanged(IInventory iinventory) {
        this.broadcastChanges();
    }

    public void setItem(int i2, int j2, net.minecraft.world.item.ItemStack itemstack) {
        this.getSlot(i2).set(itemstack);
        this.stateId = j2;
    }

    public void initializeContents(int i2, List<net.minecraft.world.item.ItemStack> list, net.minecraft.world.item.ItemStack itemstack) {
        for (int j2 = 0; j2 < list.size(); ++j2) {
            this.getSlot(j2).set(list.get(j2));
        }
        this.carried = itemstack;
        this.stateId = i2;
    }

    public void setData(int i2, int j2) {
        this.dataSlots.get(i2).set(j2);
    }

    public abstract boolean stillValid(EntityHuman var1);

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack itemstack, int i2, int j2, boolean flag) {
        int l2;
        net.minecraft.world.item.ItemStack itemstack1;
        Slot slot;
        boolean flag1 = false;
        int k2 = i2;
        if (flag) {
            k2 = j2 - 1;
        }
        if (itemstack.isStackable()) {
            while (!itemstack.isEmpty() && !(!flag ? k2 >= j2 : k2 < i2)) {
                slot = this.slots.get(k2);
                itemstack1 = slot.getItem();
                if (!itemstack1.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, itemstack1)) {
                    int i1;
                    l2 = itemstack1.getCount() + itemstack.getCount();
                    if (l2 <= (i1 = slot.getMaxStackSize(itemstack1))) {
                        itemstack.setCount(0);
                        itemstack1.setCount(l2);
                        slot.setChanged();
                        flag1 = true;
                    } else if (itemstack1.getCount() < i1) {
                        itemstack.shrink(i1 - itemstack1.getCount());
                        itemstack1.setCount(i1);
                        slot.setChanged();
                        flag1 = true;
                    }
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        if (!itemstack.isEmpty()) {
            k2 = flag ? j2 - 1 : i2;
            while (!(!flag ? k2 >= j2 : k2 < i2)) {
                slot = this.slots.get(k2);
                itemstack1 = slot.getItem();
                if (itemstack1.isEmpty() && slot.mayPlace(itemstack)) {
                    l2 = slot.getMaxStackSize(itemstack);
                    slot.setByPlayer(itemstack.split(Math.min(itemstack.getCount(), l2)));
                    slot.setChanged();
                    flag1 = true;
                    break;
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        return flag1;
    }

    public static int getQuickcraftType(int i2) {
        return i2 >> 2 & 3;
    }

    public static int getQuickcraftHeader(int i2) {
        return i2 & 3;
    }

    public static int getQuickcraftMask(int i2, int j2) {
        return i2 & 3 | (j2 & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int i2, EntityHuman entityhuman) {
        return i2 == 0 ? true : (i2 == 1 ? true : i2 == 2 && entityhuman.hasInfiniteMaterials());
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.hasItem();
        return !flag1 && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, slot.getItem()) ? slot.getItem().getCount() + (flag ? 0 : itemstack.getCount()) <= itemstack.getMaxStackSize() : flag1;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> set, int i2, net.minecraft.world.item.ItemStack itemstack) {
        return switch (i2) {
            case 0 -> MathHelper.floor((float)itemstack.getCount() / (float)set.size());
            case 1 -> 1;
            case 2 -> itemstack.getMaxStackSize();
            default -> itemstack.getCount();
        };
    }

    public boolean canDragTo(Slot slot) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable TileEntity tileentity) {
        return tileentity instanceof IInventory ? Container.getRedstoneSignalFromContainer((IInventory)((Object)tileentity)) : 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable IInventory iinventory) {
        if (iinventory == null) {
            return 0;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < iinventory.getContainerSize(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(i2);
            if (itemstack.isEmpty()) continue;
            f2 += (float)itemstack.getCount() / (float)iinventory.getMaxStackSize(itemstack);
        }
        return MathHelper.lerpDiscrete(f2 /= (float)iinventory.getContainerSize(), 0, 15);
    }

    public void setCarried(net.minecraft.world.item.ItemStack itemstack) {
        this.carried = itemstack;
    }

    public net.minecraft.world.item.ItemStack getCarried() {
        if (this.carried.isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
        }
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(Container container) {
        Slot slot;
        int i2;
        HashBasedTable table = HashBasedTable.create();
        for (i2 = 0; i2 < container.slots.size(); ++i2) {
            slot = container.slots.get(i2);
            table.put((Object)slot.container, (Object)slot.getContainerSlot(), (Object)i2);
        }
        for (i2 = 0; i2 < this.slots.size(); ++i2) {
            slot = this.slots.get(i2);
            Integer integer = (Integer)table.get((Object)slot.container, (Object)slot.getContainerSlot());
            if (integer == null) continue;
            this.lastSlots.set(i2, container.lastSlots.get(integer));
            this.remoteSlots.set(i2, container.remoteSlots.get(integer));
        }
    }

    public OptionalInt findSlot(IInventory iinventory, int i2) {
        for (int j2 = 0; j2 < this.slots.size(); ++j2) {
            Slot slot = this.slots.get(j2);
            if (slot.container != iinventory || i2 != slot.getContainerSlot()) continue;
            return OptionalInt.of(j2);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }
}

