/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import org.bukkit.Location;
import org.bukkit.World;

public interface ContainerAccess {
    public static final ContainerAccess NULL = new ContainerAccess(){

        @Override
        public <T> Optional<T> evaluate(BiFunction<net.minecraft.world.level.World, BlockPosition, T> bifunction) {
            return Optional.empty();
        }
    };

    default public net.minecraft.world.level.World getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPosition getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return new Location((World)this.getWorld().getWorld(), (double)this.getPosition().getX(), (double)this.getPosition().getY(), (double)this.getPosition().getZ());
    }

    public static ContainerAccess create(final net.minecraft.world.level.World world, final BlockPosition blockposition) {
        return new ContainerAccess(){

            @Override
            public net.minecraft.world.level.World getWorld() {
                return world;
            }

            @Override
            public BlockPosition getPosition() {
                return blockposition;
            }

            @Override
            public <T> Optional<T> evaluate(BiFunction<net.minecraft.world.level.World, BlockPosition, T> bifunction) {
                return Optional.of(bifunction.apply(world, blockposition));
            }
        };
    }

    public <T> Optional<T> evaluate(BiFunction<net.minecraft.world.level.World, BlockPosition, T> var1);

    default public <T> T evaluate(BiFunction<net.minecraft.world.level.World, BlockPosition, T> bifunction, T t0) {
        return this.evaluate(bifunction).orElse(t0);
    }

    default public void execute(BiConsumer<net.minecraft.world.level.World, BlockPosition> biconsumer) {
        this.evaluate((world, blockposition) -> {
            biconsumer.accept((net.minecraft.world.level.World)world, (BlockPosition)blockposition);
            return Optional.empty();
        });
    }
}

