/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.slf4j.Logger;

public class ContainerAnvil
extends ContainerAnvilAbstract {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    @Nullable
    public String itemName;
    public final ContainerProperty cost = ContainerProperty.standalone();
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;
    public static final int DEFAULT_DENIED_COST = -1;
    public int maximumRepairCost = 40;
    private CraftAnvilView bukkitEntity;

    public ContainerAnvil(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerAnvil(int i2, PlayerInventory playerinventory, ContainerAccess containeraccess) {
        super(Containers.ANVIL, i2, playerinventory, containeraccess);
        this.addDataSlot(this.cost);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, itemstack -> true).withSlot(1, 76, 47, itemstack -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData iblockdata) {
        return iblockdata.is(TagsBlock.ANVIL);
    }

    @Override
    protected boolean mayPickup(EntityHuman entityhuman, boolean flag) {
        return (entityhuman.hasInfiniteMaterials() || entityhuman.experienceLevel >= this.cost.get()) && this.cost.get() > -1 && flag;
    }

    @Override
    protected void onTake(EntityHuman entityhuman, ItemStack itemstack) {
        if (!entityhuman.getAbilities().instabuild) {
            entityhuman.giveExperienceLevels(-this.cost.get());
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            ItemStack itemstack1 = this.inputSlots.getItem(1);
            if (!itemstack1.isEmpty() && itemstack1.getCount() > this.repairItemCountCost) {
                itemstack1.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, itemstack1);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.cost.set(-1);
        this.access.execute((world, blockposition) -> {
            IBlockData iblockdata = world.getBlockState((BlockPosition)blockposition);
            if (!entityhuman.hasInfiniteMaterials() && iblockdata.is(TagsBlock.ANVIL) && entityhuman.getRandom().nextFloat() < 0.12f) {
                IBlockData iblockdata1 = BlockAnvil.damage(iblockdata);
                if (iblockdata1 == null) {
                    world.removeBlock((BlockPosition)blockposition, false);
                    world.levelEvent(1029, (BlockPosition)blockposition, 0);
                } else {
                    world.setBlock((BlockPosition)blockposition, iblockdata1, 2);
                    world.levelEvent(1030, (BlockPosition)blockposition, 0);
                }
            } else {
                world.levelEvent(1030, (BlockPosition)blockposition, 0);
            }
        });
    }

    @Override
    public void createResult() {
        ItemStack itemstack = this.inputSlots.getItem(0);
        this.cost.set(1);
        int i2 = 0;
        long j2 = 0L;
        int b0 = 0;
        if (!itemstack.isEmpty() && EnchantmentManager.canStoreEnchantments(itemstack)) {
            int k2;
            ItemStack itemstack1 = itemstack.copy();
            ItemStack itemstack2 = this.inputSlots.getItem(1);
            ItemEnchantments.a itemenchantments_a = new ItemEnchantments.a(EnchantmentManager.getEnchantmentsForCrafting(itemstack1));
            j2 += (long)itemstack.getOrDefault(DataComponents.REPAIR_COST, 0).intValue() + (long)itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0).intValue();
            this.repairItemCountCost = 0;
            if (!itemstack2.isEmpty()) {
                boolean flag = itemstack2.has(DataComponents.STORED_ENCHANTMENTS);
                if (itemstack1.isDamageableItem() && itemstack1.getItem().isValidRepairItem(itemstack, itemstack2)) {
                    int i1;
                    k2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    if (k2 <= 0) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    for (i1 = 0; k2 > 0 && i1 < itemstack2.getCount(); ++i1) {
                        int l2 = itemstack1.getDamageValue() - k2;
                        itemstack1.setDamageValue(l2);
                        ++i2;
                        k2 = Math.min(itemstack1.getDamageValue(), itemstack1.getMaxDamage() / 4);
                    }
                    this.repairItemCountCost = i1;
                } else {
                    if (!(flag || itemstack1.is(itemstack2.getItem()) && itemstack1.isDamageableItem())) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                    if (itemstack1.isDamageableItem() && !flag) {
                        k2 = itemstack.getMaxDamage() - itemstack.getDamageValue();
                        int i1 = itemstack2.getMaxDamage() - itemstack2.getDamageValue();
                        int l3 = i1 + itemstack1.getMaxDamage() * 12 / 100;
                        int j1 = k2 + l3;
                        int k1 = itemstack1.getMaxDamage() - j1;
                        if (k1 < 0) {
                            k1 = 0;
                        }
                        if (k1 < itemstack1.getDamageValue()) {
                            itemstack1.setDamageValue(k1);
                            i2 += 2;
                        }
                    }
                    ItemEnchantments itemenchantments = EnchantmentManager.getEnchantmentsForCrafting(itemstack2);
                    boolean flag1 = false;
                    boolean flag2 = false;
                    for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                        int i22;
                        Holder holder = (Holder)entry.getKey();
                        int l1 = itemenchantments_a.getLevel(holder);
                        i22 = l1 == (i22 = entry.getIntValue()) ? i22 + 1 : Math.max(i22, l1);
                        Enchantment enchantment = (Enchantment)holder.value();
                        boolean flag3 = enchantment.canEnchant(itemstack);
                        if (this.player.getAbilities().instabuild || itemstack.is(Items.ENCHANTED_BOOK)) {
                            flag3 = true;
                        }
                        for (Holder<Enchantment> holder1 : itemenchantments_a.keySet()) {
                            if (holder1.equals(holder) || Enchantment.areCompatible(holder, holder1)) continue;
                            flag3 = false;
                            ++i2;
                        }
                        if (!flag3) {
                            flag2 = true;
                            continue;
                        }
                        flag1 = true;
                        if (i22 > enchantment.getMaxLevel()) {
                            i22 = enchantment.getMaxLevel();
                        }
                        itemenchantments_a.set(holder, i22);
                        int j22 = enchantment.getAnvilCost();
                        if (flag) {
                            j22 = Math.max(1, j22 / 2);
                        }
                        i2 += j22 * i22;
                        if (itemstack.getCount() <= 1) continue;
                        i2 = 40;
                    }
                    if (flag2 && !flag1) {
                        CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
                        this.cost.set(-1);
                        return;
                    }
                }
            }
            if (this.itemName != null && !UtilColor.isBlank(this.itemName)) {
                if (!this.itemName.equals(itemstack.getHoverName().getString())) {
                    b0 = 1;
                    i2 += b0;
                    itemstack1.set(DataComponents.CUSTOM_NAME, IChatBaseComponent.literal(this.itemName));
                }
            } else if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                b0 = 1;
                i2 += b0;
                itemstack1.remove(DataComponents.CUSTOM_NAME);
            }
            int k22 = (int)MathHelper.clamp(j2 + (long)i2, 0L, Integer.MAX_VALUE);
            this.cost.set(k22);
            if (i2 <= 0) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (b0 == i2 && b0 > 0 && this.cost.get() >= this.maximumRepairCost) {
                this.cost.set(this.maximumRepairCost - 1);
            }
            if (this.cost.get() >= this.maximumRepairCost && !this.player.getAbilities().instabuild) {
                itemstack1 = ItemStack.EMPTY;
            }
            if (!itemstack1.isEmpty()) {
                k2 = itemstack1.getOrDefault(DataComponents.REPAIR_COST, 0);
                if (k2 < itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0)) {
                    k2 = itemstack2.getOrDefault(DataComponents.REPAIR_COST, 0);
                }
                if (b0 != i2 || b0 == 0) {
                    k2 = ContainerAnvil.calculateIncreasedRepairCost(k2);
                }
                itemstack1.set(DataComponents.REPAIR_COST, k2);
                EnchantmentManager.setEnchantments(itemstack1, itemenchantments_a.toImmutable());
            }
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), itemstack1);
            this.sendAllDataToRemote();
            this.broadcastChanges();
        } else {
            CraftEventFactory.callPrepareAnvilEvent(this.getBukkitView(), ItemStack.EMPTY);
            this.cost.set(-1);
        }
    }

    public static int calculateIncreasedRepairCost(int i2) {
        return (int)Math.min((long)i2 * 2L + 1L, Integer.MAX_VALUE);
    }

    public boolean setItemName(String s2) {
        String s1 = ContainerAnvil.validateName(s2);
        if (s1 != null && !s1.equals(this.itemName)) {
            this.itemName = s1;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemstack = this.getSlot(2).getItem();
                if (UtilColor.isBlank(s1)) {
                    itemstack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemstack.set(DataComponents.CUSTOM_NAME, IChatBaseComponent.literal(s1));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String s2) {
        String s1 = UtilColor.filterText(s2);
        return s1.length() <= 50 ? s1 : null;
    }

    public int getCost() {
        return this.cost.get();
    }

    @Override
    public CraftAnvilView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftAnvilView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        this.bukkitEntity.updateFromLegacy(inventory);
        return this.bukkitEntity;
    }
}

