/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class ContainerAnvilAbstract
extends Container {
    private static final int INVENTORY_SLOTS_PER_ROW = 9;
    private static final int INVENTORY_SLOTS_PER_COLUMN = 3;
    protected final ContainerAccess access;
    protected final EntityHuman player;
    protected final IInventory inputSlots;
    private final List<Integer> inputSlotIndexes;
    protected final InventoryCraftResult resultSlots = new InventoryCraftResult();
    private final int resultSlotIndex;

    protected abstract boolean mayPickup(EntityHuman var1, boolean var2);

    protected abstract void onTake(EntityHuman var1, ItemStack var2);

    protected abstract boolean isValidBlock(IBlockData var1);

    public ContainerAnvilAbstract(@Nullable Containers<?> containers, int i2, PlayerInventory playerinventory, ContainerAccess containeraccess) {
        super(containers, i2);
        this.access = containeraccess;
        this.player = playerinventory.player;
        ItemCombinerMenuSlotDefinition itemcombinermenuslotdefinition = this.createInputSlotDefinitions();
        this.inputSlots = this.createContainer(itemcombinermenuslotdefinition.getNumOfInputSlots());
        this.inputSlotIndexes = itemcombinermenuslotdefinition.getInputSlotIndexes();
        this.resultSlotIndex = itemcombinermenuslotdefinition.getResultSlotIndex();
        this.createInputSlots(itemcombinermenuslotdefinition);
        this.createResultSlot(itemcombinermenuslotdefinition);
        this.createInventorySlots(playerinventory);
    }

    private void createInputSlots(ItemCombinerMenuSlotDefinition itemcombinermenuslotdefinition) {
        for (final ItemCombinerMenuSlotDefinition.b itemcombinermenuslotdefinition_b : itemcombinermenuslotdefinition.getSlots()) {
            this.addSlot(new Slot(this, this.inputSlots, itemcombinermenuslotdefinition_b.slotIndex(), itemcombinermenuslotdefinition_b.x(), itemcombinermenuslotdefinition_b.y()){

                @Override
                public boolean mayPlace(ItemStack itemstack) {
                    return itemcombinermenuslotdefinition_b.mayPlace().test(itemstack);
                }
            });
        }
    }

    private void createResultSlot(ItemCombinerMenuSlotDefinition itemcombinermenuslotdefinition) {
        this.addSlot(new Slot(this.resultSlots, itemcombinermenuslotdefinition.getResultSlot().slotIndex(), itemcombinermenuslotdefinition.getResultSlot().x(), itemcombinermenuslotdefinition.getResultSlot().y()){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public boolean mayPickup(EntityHuman entityhuman) {
                return ContainerAnvilAbstract.this.mayPickup(entityhuman, this.hasItem());
            }

            @Override
            public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
                ContainerAnvilAbstract.this.onTake(entityhuman, itemstack);
            }
        });
    }

    private void createInventorySlots(PlayerInventory playerinventory) {
        int i2;
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j2 = 0; j2 < 9; ++j2) {
                this.addSlot(new Slot(playerinventory, j2 + i2 * 9 + 9, 8 + j2 * 18, 84 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 9; ++i2) {
            this.addSlot(new Slot(playerinventory, i2, 8 + i2 * 18, 142));
        }
    }

    public abstract void createResult();

    protected abstract ItemCombinerMenuSlotDefinition createInputSlotDefinitions();

    private InventorySubcontainer createContainer(int i2) {
        return new InventorySubcontainer(i2){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerAnvilAbstract.this.slotsChanged(this);
            }
        };
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        super.slotsChanged(iinventory);
        if (iinventory == this.inputSlots) {
            this.createResult();
        }
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.inputSlots));
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.access.evaluate((world, blockposition) -> !this.isValidBlock(world.getBlockState((BlockPosition)blockposition)) ? false : entityhuman.canInteractWithBlock((BlockPosition)blockposition, 4.0), true);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            int l2;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int j2 = this.getInventorySlotStart();
            int k2 = this.getUseRowEnd();
            if (i2 == this.getResultSlot()) {
                if (!this.moveItemStackTo(itemstack1, j2, k2, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (this.inputSlotIndexes.contains(i2) ? !this.moveItemStackTo(itemstack1, j2, k2, false) : (this.canMoveIntoInputSlots(itemstack1) && i2 >= this.getInventorySlotStart() && i2 < this.getUseRowEnd() ? !this.moveItemStackTo(itemstack1, l2 = this.getSlotToQuickMoveTo(itemstack), this.getResultSlot(), false) : (i2 >= this.getInventorySlotStart() && i2 < this.getInventorySlotEnd() ? !this.moveItemStackTo(itemstack1, this.getUseRowStart(), this.getUseRowEnd(), false) : i2 >= this.getUseRowStart() && i2 < this.getUseRowEnd() && !this.moveItemStackTo(itemstack1, this.getInventorySlotStart(), this.getInventorySlotEnd(), false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    protected boolean canMoveIntoInputSlots(ItemStack itemstack) {
        return true;
    }

    public int getSlotToQuickMoveTo(ItemStack itemstack) {
        return this.inputSlots.isEmpty() ? 0 : this.inputSlotIndexes.get(0);
    }

    public int getResultSlot() {
        return this.resultSlotIndex;
    }

    private int getInventorySlotStart() {
        return this.getResultSlot() + 1;
    }

    private int getInventorySlotEnd() {
        return this.getInventorySlotStart() + 27;
    }

    private int getUseRowStart() {
        return this.getInventorySlotEnd();
    }

    private int getUseRowEnd() {
        return this.getUseRowStart() + 9;
    }
}

