/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftBeaconView;
import org.bukkit.entity.HumanEntity;

public class ContainerBeacon
extends Container {
    private static final int PAYMENT_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 1;
    private static final int INV_SLOT_END = 28;
    private static final int USE_ROW_SLOT_START = 28;
    private static final int USE_ROW_SLOT_END = 37;
    private static final int NO_EFFECT = 0;
    private final IInventory beacon;
    private final SlotBeacon paymentSlot;
    private final ContainerAccess access;
    private final IContainerProperties beaconData;
    private CraftBeaconView bukkitEntity = null;
    private PlayerInventory player;

    public ContainerBeacon(int i2, IInventory iinventory) {
        this(i2, iinventory, new ContainerProperties(3), ContainerAccess.NULL);
    }

    public ContainerBeacon(int i2, IInventory iinventory, IContainerProperties icontainerproperties, ContainerAccess containeraccess) {
        super(Containers.BEACON, i2);
        int j2;
        this.player = (PlayerInventory)iinventory;
        this.beacon = new InventorySubcontainer(this, 1){

            @Override
            public boolean canPlaceItem(int j2, ItemStack itemstack) {
                return itemstack.is(TagsItem.BEACON_PAYMENT_ITEMS);
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        };
        ContainerBeacon.checkContainerDataCount(icontainerproperties, 3);
        this.beaconData = icontainerproperties;
        this.access = containeraccess;
        this.paymentSlot = new SlotBeacon(this, this, this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(icontainerproperties);
        boolean flag = true;
        boolean flag1 = true;
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(iinventory, k2 + j2 * 9 + 9, 36 + k2 * 18, 137 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(iinventory, j2, 36 + j2 * 18, 195));
        }
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        ItemStack itemstack;
        super.removed(entityhuman);
        if (!entityhuman.level().isClientSide && !(itemstack = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize())).isEmpty()) {
            entityhuman.drop(itemstack, false);
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerBeacon.stillValid(this.access, entityhuman, Blocks.BEACON);
    }

    @Override
    public void setData(int i2, int j2) {
        super.setData(i2, j2);
        this.broadcastChanges();
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 0) {
                if (!this.moveItemStackTo(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.paymentSlot.hasItem() && this.paymentSlot.mayPlace(itemstack1) && itemstack1.getCount() == 1 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i2 >= 1 && i2 < 28 ? !this.moveItemStackTo(itemstack1, 28, 37, false) : (i2 >= 28 && i2 < 37 ? !this.moveItemStackTo(itemstack1, 1, 28, false) : !this.moveItemStackTo(itemstack1, 1, 37, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    public static int encodeEffect(@Nullable Holder<MobEffectList> holder) {
        return holder == null ? 0 : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().getId(holder) + 1;
    }

    @Nullable
    public static Holder<MobEffectList> decodeEffect(int i2) {
        return i2 == 0 ? null : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().byId(i2 - 1);
    }

    @Nullable
    public Holder<MobEffectList> getPrimaryEffect() {
        return ContainerBeacon.decodeEffect(this.beaconData.get(1));
    }

    @Nullable
    public Holder<MobEffectList> getSecondaryEffect() {
        return ContainerBeacon.decodeEffect(this.beaconData.get(2));
    }

    public void updateEffects(Optional<Holder<MobEffectList>> optional, Optional<Holder<MobEffectList>> optional1) {
        if (this.paymentSlot.hasItem()) {
            this.beaconData.set(1, ContainerBeacon.encodeEffect(optional.orElse(null)));
            this.beaconData.set(2, ContainerBeacon.encodeEffect(optional1.orElse(null)));
            this.paymentSlot.remove(1);
            this.access.execute(World::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    @Override
    public CraftBeaconView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryBeacon inventory = new CraftInventoryBeacon(this.beacon);
        this.bukkitEntity = new CraftBeaconView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    private class SlotBeacon
    extends Slot {
        public SlotBeacon(ContainerBeacon containerBeacon, ContainerBeacon containerbeacon, IInventory iinventory, int i2, int j2, int k2) {
            super(iinventory, i2, j2, k2);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return itemstack.is(TagsItem.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }
}

