/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftBrewingStandView;
import org.bukkit.entity.HumanEntity;

public class ContainerBrewingStand
extends Container {
    private static final int BOTTLE_SLOT_START = 0;
    private static final int BOTTLE_SLOT_END = 2;
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int SLOT_COUNT = 5;
    private static final int DATA_COUNT = 2;
    private static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    private final IInventory brewingStand;
    private final IContainerProperties brewingStandData;
    private final Slot ingredientSlot;
    private CraftBrewingStandView bukkitEntity = null;
    private PlayerInventory player;

    public ContainerBrewingStand(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, new InventorySubcontainer(5), new ContainerProperties(2));
    }

    public ContainerBrewingStand(int i2, PlayerInventory playerinventory, IInventory iinventory, IContainerProperties icontainerproperties) {
        super(Containers.BREWING_STAND, i2);
        int j2;
        this.player = playerinventory;
        ContainerBrewingStand.checkContainerSize(iinventory, 5);
        ContainerBrewingStand.checkContainerDataCount(icontainerproperties, 2);
        this.brewingStand = iinventory;
        this.brewingStandData = icontainerproperties;
        PotionBrewer potionbrewer = playerinventory.player.level().potionBrewing();
        this.addSlot(new SlotPotionBottle(iinventory, 0, 56, 51));
        this.addSlot(new SlotPotionBottle(iinventory, 1, 79, 58));
        this.addSlot(new SlotPotionBottle(iinventory, 2, 102, 51));
        this.ingredientSlot = this.addSlot(new SlotBrewing(potionbrewer, iinventory, 3, 79, 17));
        this.addSlot(new a(iinventory, 4, 17, 17));
        this.addDataSlots(icontainerproperties);
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.brewingStand.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if ((i2 < 0 || i2 > 2) && i2 != 3 && i2 != 4) {
                if (a.mayPlaceItem(itemstack) ? this.moveItemStackTo(itemstack1, 4, 5, false) || this.ingredientSlot.mayPlace(itemstack1) && !this.moveItemStackTo(itemstack1, 3, 4, false) : (this.ingredientSlot.mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (SlotPotionBottle.mayPlaceItem(itemstack) ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (i2 >= 5 && i2 < 32 ? !this.moveItemStackTo(itemstack1, 32, 41, false) : (i2 >= 32 && i2 < 41 ? !this.moveItemStackTo(itemstack1, 5, 32, false) : !this.moveItemStackTo(itemstack1, 5, 41, false)))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(itemstack1, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack);
        }
        return itemstack;
    }

    public int getFuel() {
        return this.brewingStandData.get(1);
    }

    public int getBrewingTicks() {
        return this.brewingStandData.get(0);
    }

    @Override
    public CraftBrewingStandView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryBrewer inventory = new CraftInventoryBrewer(this.brewingStand);
        this.bukkitEntity = new CraftBrewingStandView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    private static class SlotPotionBottle
    extends Slot {
        public SlotPotionBottle(IInventory iinventory, int i2, int j2, int k2) {
            super(iinventory, i2, j2, k2);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return SlotPotionBottle.mayPlaceItem(itemstack);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
            Optional<Holder<PotionRegistry>> optional = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
            if (optional.isPresent() && entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                CriterionTriggers.BREWED_POTION.trigger(entityplayer, optional.get());
            }
            super.onTake(entityhuman, itemstack);
        }

        public static boolean mayPlaceItem(ItemStack itemstack) {
            return itemstack.is(Items.POTION) || itemstack.is(Items.SPLASH_POTION) || itemstack.is(Items.LINGERING_POTION) || itemstack.is(Items.GLASS_BOTTLE);
        }
    }

    private static class SlotBrewing
    extends Slot {
        private final PotionBrewer potionBrewing;

        public SlotBrewing(PotionBrewer potionbrewer, IInventory iinventory, int i2, int j2, int k2) {
            super(iinventory, i2, j2, k2);
            this.potionBrewing = potionbrewer;
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return this.potionBrewing.isIngredient(itemstack);
        }
    }

    private static class a
    extends Slot {
        public a(IInventory iinventory, int i2, int j2, int k2) {
            super(iinventory, i2, j2, k2);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return a.mayPlaceItem(itemstack);
        }

        public static boolean mayPlaceItem(ItemStack itemstack) {
            return itemstack.is(Items.BLAZE_POWDER);
        }
    }
}

