/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ContainerCartography
extends Container {
    private CraftInventoryView bukkitEntity = null;
    private Player player;
    public static final int MAP_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ContainerAccess access;
    long lastSoundTime;
    public final IInventory container;
    private final InventoryCraftResult resultContainer;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCartography inventory = new CraftInventoryCartography(this.container, this.resultContainer);
        this.bukkitEntity = new CraftInventoryView<ContainerCartography, CraftInventoryCartography>((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerCartography(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerCartography(int i2, PlayerInventory playerinventory, final ContainerAccess containeraccess) {
        super(Containers.CARTOGRAPHY_TABLE, i2);
        int j2;
        this.container = new InventorySubcontainer(2){

            @Override
            public void setChanged() {
                ContainerCartography.this.slotsChanged(this);
                super.setChanged();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.resultContainer = new InventoryCraftResult(){

            @Override
            public void setChanged() {
                ContainerCartography.this.slotsChanged(this);
                super.setChanged();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.access = containeraccess;
        this.addSlot(new Slot(this, this.container, 0, 15, 15){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.is(Items.FILLED_MAP);
            }
        });
        this.addSlot(new Slot(this, this.container, 1, 15, 52){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.is(Items.PAPER) || itemstack.is(Items.MAP) || itemstack.is(Items.GLASS_PANE);
            }
        });
        this.addSlot(new Slot(this.resultContainer, 2, 145, 39){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
                ((Slot)ContainerCartography.this.slots.get(0)).remove(1);
                ((Slot)ContainerCartography.this.slots.get(1)).remove(1);
                itemstack.getItem().onCraftedBy(itemstack, entityhuman.level(), entityhuman);
                containeraccess.execute((world, blockposition) -> {
                    long j2 = world.getGameTime();
                    if (ContainerCartography.this.lastSoundTime != j2) {
                        world.playSound((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerCartography.this.lastSoundTime = j2;
                    }
                });
                super.onTake(entityhuman, itemstack);
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerCartography.stillValid(this.access, entityhuman, Blocks.CARTOGRAPHY_TABLE);
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        ItemStack itemstack = this.container.getItem(0);
        ItemStack itemstack1 = this.container.getItem(1);
        ItemStack itemstack2 = this.resultContainer.getItem(2);
        if (!itemstack2.isEmpty() && (itemstack.isEmpty() || itemstack1.isEmpty())) {
            this.resultContainer.removeItemNoUpdate(2);
        } else if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
            this.setupResultSlot(itemstack, itemstack1, itemstack2);
        }
    }

    private void setupResultSlot(ItemStack itemstack, ItemStack itemstack1, ItemStack itemstack2) {
        this.access.execute((world, blockposition) -> {
            WorldMap worldmap = ItemWorldMap.getSavedData(itemstack, world);
            if (worldmap != null) {
                ItemStack itemstack3;
                if (itemstack1.is(Items.PAPER) && !worldmap.locked && worldmap.scale < 4) {
                    itemstack3 = itemstack.copyWithCount(1);
                    itemstack3.set(DataComponents.MAP_POST_PROCESSING, MapPostProcessing.SCALE);
                    this.broadcastChanges();
                } else if (itemstack1.is(Items.GLASS_PANE) && !worldmap.locked) {
                    itemstack3 = itemstack.copyWithCount(1);
                    itemstack3.set(DataComponents.MAP_POST_PROCESSING, MapPostProcessing.LOCK);
                    this.broadcastChanges();
                } else {
                    if (!itemstack1.is(Items.MAP)) {
                        this.resultContainer.removeItemNoUpdate(2);
                        this.broadcastChanges();
                        return;
                    }
                    itemstack3 = itemstack.copyWithCount(2);
                    this.broadcastChanges();
                }
                if (!ItemStack.matches(itemstack3, itemstack2)) {
                    this.resultContainer.setItem(2, itemstack3);
                    this.broadcastChanges();
                }
            }
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 2) {
                itemstack1.getItem().onCraftedBy(itemstack1, entityhuman.level(), entityhuman);
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 != 1 && i2 != 0 ? (itemstack1.is(Items.FILLED_MAP) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (!itemstack1.is(Items.PAPER) && !itemstack1.is(Items.MAP) && !itemstack1.is(Items.GLASS_PANE) ? (i2 >= 3 && i2 < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i2 >= 30 && i2 < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 1, 2, false))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.resultContainer.removeItemNoUpdate(2);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.container));
    }
}

