/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerChest
extends Container {
    private static final int SLOTS_PER_ROW = 9;
    private final IInventory container;
    private final int containerRows;
    private CraftInventoryView bukkitEntity = null;
    private PlayerInventory player;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = this.container instanceof PlayerInventory ? new CraftInventoryPlayer((PlayerInventory)this.container) : (this.container instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)this.container) : new CraftInventory(this.container));
        this.bukkitEntity = new CraftInventoryView<ContainerChest, CraftInventoryPlayer>(this.player.player.getBukkitEntity(), (CraftInventoryPlayer)inventory, this);
        return this.bukkitEntity;
    }

    private ContainerChest(Containers<?> containers, int i2, PlayerInventory playerinventory, int j2) {
        this(containers, i2, playerinventory, new InventorySubcontainer(9 * j2), j2);
    }

    public static ContainerChest oneRow(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x1, i2, playerinventory, 1);
    }

    public static ContainerChest twoRows(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x2, i2, playerinventory, 2);
    }

    public static ContainerChest threeRows(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x3, i2, playerinventory, 3);
    }

    public static ContainerChest fourRows(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x4, i2, playerinventory, 4);
    }

    public static ContainerChest fiveRows(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x5, i2, playerinventory, 5);
    }

    public static ContainerChest sixRows(int i2, PlayerInventory playerinventory) {
        return new ContainerChest(Containers.GENERIC_9x6, i2, playerinventory, 6);
    }

    public static ContainerChest threeRows(int i2, PlayerInventory playerinventory, IInventory iinventory) {
        return new ContainerChest(Containers.GENERIC_9x3, i2, playerinventory, iinventory, 3);
    }

    public static ContainerChest sixRows(int i2, PlayerInventory playerinventory, IInventory iinventory) {
        return new ContainerChest(Containers.GENERIC_9x6, i2, playerinventory, iinventory, 6);
    }

    public ContainerChest(Containers<?> containers, int i2, PlayerInventory playerinventory, IInventory iinventory, int j2) {
        super(containers, i2);
        int i1;
        int l2;
        ContainerChest.checkContainerSize(iinventory, j2 * 9);
        this.container = iinventory;
        this.containerRows = j2;
        iinventory.startOpen(playerinventory.player);
        int k2 = (this.containerRows - 4) * 18;
        this.player = playerinventory;
        for (l2 = 0; l2 < this.containerRows; ++l2) {
            for (i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot(iinventory, i1 + l2 * 9, 8 + i1 * 18, 18 + l2 * 18));
            }
        }
        for (l2 = 0; l2 < 3; ++l2) {
            for (i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot(playerinventory, i1 + l2 * 9 + 9, 8 + i1 * 18, 103 + l2 * 18 + k2));
            }
        }
        for (l2 = 0; l2 < 9; ++l2) {
            this.addSlot(new Slot(playerinventory, l2, 8 + l2 * 18, 161 + k2));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 < this.containerRows * 9 ? !this.moveItemStackTo(itemstack1, this.containerRows * 9, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.containerRows * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.container.stopOpen(entityhuman);
    }

    public IInventory getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }
}

