/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerDispenser
extends Container {
    private static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    public final IInventory dispenser;
    private CraftInventoryView bukkitEntity = null;
    private PlayerInventory player;

    public ContainerDispenser(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, new InventorySubcontainer(9));
    }

    public ContainerDispenser(int i2, PlayerInventory playerinventory, IInventory iinventory) {
        super(Containers.GENERIC_3x3, i2);
        int k2;
        int j2;
        this.player = playerinventory;
        ContainerDispenser.checkContainerSize(iinventory, 9);
        this.dispenser = iinventory;
        iinventory.startOpen(playerinventory.player);
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 3; ++k2) {
                this.addSlot(new Slot(iinventory, k2 + j2 * 3, 62 + k2 * 18, 17 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.dispenser.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, true) : !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.dispenser.stopOpen(entityhuman);
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = new CraftInventory(this.dispenser);
        this.bukkitEntity = new CraftInventoryView<ContainerDispenser, CraftInventory>(this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

