/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.block.BlockEnchantmentTable;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftEnchantmentView;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.EnchantmentView;

public class ContainerEnchantTable
extends Container {
    static final MinecraftKey EMPTY_SLOT_LAPIS_LAZULI = MinecraftKey.withDefaultNamespace("item/empty_slot_lapis_lazuli");
    private final IInventory enchantSlots;
    private final ContainerAccess access;
    private final RandomSource random;
    private final ContainerProperty enchantmentSeed;
    public final int[] costs;
    public final int[] enchantClue;
    public final int[] levelClue;
    private CraftEnchantmentView bukkitEntity = null;
    private Player player;

    public ContainerEnchantTable(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerEnchantTable(int i2, PlayerInventory playerinventory, final ContainerAccess containeraccess) {
        super(Containers.ENCHANTMENT, i2);
        int j2;
        this.enchantSlots = new InventorySubcontainer(2){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerEnchantTable.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.random = RandomSource.create();
        this.enchantmentSeed = ContainerProperty.standalone();
        this.costs = new int[3];
        this.enchantClue = new int[]{-1, -1, -1};
        this.levelClue = new int[]{-1, -1, -1};
        this.access = containeraccess;
        this.addSlot(new Slot(this, this.enchantSlots, 0, 15, 47){

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this, this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(net.minecraft.world.item.ItemStack itemstack) {
                return itemstack.is(Items.LAPIS_LAZULI);
            }

            @Override
            public Pair<MinecraftKey, MinecraftKey> getNoItemIcon() {
                return Pair.of((Object)ContainerPlayer.BLOCK_ATLAS, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.addDataSlot(ContainerProperty.shared(this.costs, 0));
        this.addDataSlot(ContainerProperty.shared(this.costs, 1));
        this.addDataSlot(ContainerProperty.shared(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(playerinventory.player.getEnchantmentSeed());
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 0));
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 1));
        this.addDataSlot(ContainerProperty.shared(this.enchantClue, 2));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 0));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 1));
        this.addDataSlot(ContainerProperty.shared(this.levelClue, 2));
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        if (iinventory == this.enchantSlots) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(0);
            if (!itemstack.isEmpty()) {
                this.access.execute((world, blockposition) -> {
                    int j2;
                    Registry<Holder<Enchantment>> registry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    int i2 = 0;
                    for (BlockPosition blockposition1 : BlockEnchantmentTable.BOOKSHELF_OFFSETS) {
                        if (!BlockEnchantmentTable.isValidBookShelf(world, blockposition, blockposition1)) continue;
                        ++i2;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    for (j2 = 0; j2 < 3; ++j2) {
                        this.costs[j2] = EnchantmentManager.getEnchantmentCost(this.random, j2, i2, itemstack);
                        this.enchantClue[j2] = -1;
                        this.levelClue[j2] = -1;
                        if (this.costs[j2] >= j2 + 1) continue;
                        this.costs[j2] = 0;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        List<WeightedRandomEnchant> list;
                        if (this.costs[j2] <= 0 || (list = this.getEnchantmentList(world.registryAccess(), itemstack, j2, this.costs[j2])) == null || list.isEmpty()) continue;
                        WeightedRandomEnchant weightedrandomenchant = list.get(this.random.nextInt(list.size()));
                        this.enchantClue[j2] = registry.getId(weightedrandomenchant.enchantment);
                        this.levelClue[j2] = weightedrandomenchant.level;
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack);
                    EnchantmentOffer[] offers = new EnchantmentOffer[3];
                    for (j2 = 0; j2 < 3; ++j2) {
                        org.bukkit.enchantments.Enchantment enchantment = this.enchantClue[j2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.byId(this.enchantClue[j2])) : null;
                        offers[j2] = enchantment != null ? new EnchantmentOffer(enchantment, this.levelClue[j2], this.costs[j2]) : null;
                    }
                    PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(this.player, (EnchantmentView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)item, offers, i2);
                    event.setCancelled(!itemstack.isEnchantable());
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        for (j2 = 0; j2 < 3; ++j2) {
                            this.costs[j2] = 0;
                            this.enchantClue[j2] = -1;
                            this.levelClue[j2] = -1;
                        }
                        return;
                    }
                    for (j2 = 0; j2 < 3; ++j2) {
                        EnchantmentOffer offer = event.getOffers()[j2];
                        if (offer != null) {
                            this.costs[j2] = offer.getCost();
                            this.enchantClue[j2] = registry.getId(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
                            this.levelClue[j2] = offer.getEnchantmentLevel();
                            continue;
                        }
                        this.costs[j2] = 0;
                        this.enchantClue[j2] = -1;
                        this.levelClue[j2] = -1;
                    }
                    this.broadcastChanges();
                });
            } else {
                for (int i2 = 0; i2 < 3; ++i2) {
                    this.costs[i2] = 0;
                    this.enchantClue[i2] = -1;
                    this.levelClue[i2] = -1;
                }
            }
        }
    }

    @Override
    public boolean clickMenuButton(EntityHuman entityhuman, int i2) {
        if (i2 >= 0 && i2 < this.costs.length) {
            net.minecraft.world.item.ItemStack itemstack = this.enchantSlots.getItem(0);
            net.minecraft.world.item.ItemStack itemstack1 = this.enchantSlots.getItem(1);
            int j2 = i2 + 1;
            if ((itemstack1.isEmpty() || itemstack1.getCount() < j2) && !entityhuman.hasInfiniteMaterials()) {
                return false;
            }
            if (this.costs[i2] > 0 && !itemstack.isEmpty() && (entityhuman.experienceLevel >= j2 && entityhuman.experienceLevel >= this.costs[i2] || entityhuman.getAbilities().instabuild)) {
                this.access.execute((world, blockposition) -> {
                    net.minecraft.world.item.ItemStack itemstack2 = itemstack;
                    List<WeightedRandomEnchant> list = this.getEnchantmentList(world.registryAccess(), itemstack, i2, this.costs[i2]);
                    Registry<Holder<Enchantment>> registry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).asHolderIdMap();
                    HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                    for (WeightedRandomEnchant instance : list) {
                        enchants.put(CraftEnchantment.minecraftHolderToBukkit(instance.enchantment), instance.level);
                    }
                    CraftItemStack item = CraftItemStack.asCraftMirror(itemstack2);
                    org.bukkit.enchantments.Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit(registry.byId(this.enchantClue[i2]));
                    int hintedEnchantmentLevel = this.levelClue[i2];
                    EnchantItemEvent event = new EnchantItemEvent((Player)entityhuman.getBukkitEntity(), (InventoryView)this.getBukkitView(), this.access.getLocation().getBlock(), (ItemStack)item, this.costs[i2], enchants, hintedEnchantment, hintedEnchantmentLevel, i2);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    int level = event.getExpLevelCost();
                    if (event.isCancelled() || level > entityhuman.experienceLevel && !entityhuman.getAbilities().instabuild || event.getEnchantsToAdd().isEmpty()) {
                        return;
                    }
                    if (itemstack.is(Items.BOOK)) {
                        itemstack2 = itemstack.transmuteCopy(Items.ENCHANTED_BOOK);
                        this.enchantSlots.setItem(0, itemstack2);
                    }
                    for (Map.Entry entry : event.getEnchantsToAdd().entrySet()) {
                        Holder<Enchantment> nms = CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)entry.getKey());
                        if (nms == null) continue;
                        WeightedRandomEnchant weightedrandomenchant = new WeightedRandomEnchant(nms, (Integer)entry.getValue());
                        itemstack2.enchant(weightedrandomenchant.enchantment, weightedrandomenchant.level);
                    }
                    entityhuman.onEnchantmentPerformed(itemstack, j2);
                    itemstack1.consume(j2, entityhuman);
                    if (itemstack1.isEmpty()) {
                        this.enchantSlots.setItem(1, net.minecraft.world.item.ItemStack.EMPTY);
                    }
                    entityhuman.awardStat(StatisticList.ENCHANT_ITEM);
                    if (entityhuman instanceof EntityPlayer) {
                        CriterionTriggers.ENCHANTED_ITEM.trigger((EntityPlayer)entityhuman, itemstack2, j2);
                    }
                    this.enchantSlots.setChanged();
                    this.enchantmentSeed.set(entityhuman.getEnchantmentSeed());
                    this.slotsChanged(this.enchantSlots);
                    world.playSound((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.ENCHANTMENT_TABLE_USE, SoundCategory.BLOCKS, 1.0f, world.random.nextFloat() * 0.1f + 0.9f);
                });
                return true;
            }
            return false;
        }
        String s2 = String.valueOf(entityhuman.getName());
        SystemUtils.logAndPauseIfInIde(s2 + " pressed invalid button id: " + i2);
        return false;
    }

    private List<WeightedRandomEnchant> getEnchantmentList(IRegistryCustom iregistrycustom, net.minecraft.world.item.ItemStack itemstack, int i2, int j2) {
        this.random.setSeed(this.enchantmentSeed.get() + i2);
        Optional<HolderSet.Named<Enchantment>> optional = iregistrycustom.registryOrThrow(Registries.ENCHANTMENT).getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (optional.isEmpty()) {
            return List.of();
        }
        List<WeightedRandomEnchant> list = EnchantmentManager.selectEnchantment(this.random, itemstack, j2, optional.get().stream());
        if (itemstack.is(Items.BOOK) && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    public int getGoldCount() {
        net.minecraft.world.item.ItemStack itemstack = this.enchantSlots.getItem(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.enchantSlots));
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerEnchantTable.stillValid(this.access, entityhuman, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public net.minecraft.world.item.ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        net.minecraft.world.item.ItemStack itemstack = net.minecraft.world.item.ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            net.minecraft.world.item.ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (i2 == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else if (itemstack1.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, true)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.get(0)).hasItem() || !((Slot)this.slots.get(0)).mayPlace(itemstack1)) {
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                net.minecraft.world.item.ItemStack itemstack2 = itemstack1.copyWithCount(1);
                itemstack1.shrink(1);
                ((Slot)this.slots.get(0)).setByPlayer(itemstack2);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return net.minecraft.world.item.ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public CraftEnchantmentView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.enchantSlots);
        this.bukkitEntity = new CraftEnchantmentView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }
}

