/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotFurnaceFuel;
import net.minecraft.world.inventory.SlotFurnaceResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftFurnaceView;
import org.bukkit.entity.HumanEntity;

public abstract class ContainerFurnace
extends ContainerRecipeBook<SingleRecipeInput, RecipeCooking> {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final IInventory container;
    private final IContainerProperties data;
    protected final World level;
    private final Recipes<? extends RecipeCooking> recipeType;
    private final RecipeBookType recipeBookType;
    private CraftFurnaceView bukkitEntity = null;
    private PlayerInventory player;

    @Override
    public CraftFurnaceView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryFurnace inventory = new CraftInventoryFurnace((TileEntityFurnace)this.container);
        this.bukkitEntity = new CraftFurnaceView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    protected ContainerFurnace(Containers<?> containers, Recipes<? extends RecipeCooking> recipes, RecipeBookType recipebooktype, int i2, PlayerInventory playerinventory) {
        this(containers, recipes, recipebooktype, i2, playerinventory, new InventorySubcontainer(3), new ContainerProperties(4));
    }

    protected ContainerFurnace(Containers<?> containers, Recipes<? extends RecipeCooking> recipes, RecipeBookType recipebooktype, int i2, PlayerInventory playerinventory, IInventory iinventory, IContainerProperties icontainerproperties) {
        super(containers, i2);
        int j2;
        this.recipeType = recipes;
        this.recipeBookType = recipebooktype;
        ContainerFurnace.checkContainerSize(iinventory, 3);
        ContainerFurnace.checkContainerDataCount(icontainerproperties, 4);
        this.container = iinventory;
        this.data = icontainerproperties;
        this.level = playerinventory.player.level();
        this.addSlot(new Slot(iinventory, 0, 56, 17));
        this.addSlot(new SlotFurnaceFuel(this, iinventory, 1, 56, 53));
        this.addSlot(new SlotFurnaceResult(playerinventory.player, iinventory, 2, 116, 35));
        this.player = playerinventory;
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.addDataSlots(icontainerproperties);
    }

    @Override
    public void fillCraftSlotsStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        if (this.container instanceof AutoRecipeOutput) {
            ((AutoRecipeOutput)((Object)this.container)).fillStackedContents(autorecipestackmanager);
        }
    }

    @Override
    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(2).set(ItemStack.EMPTY);
    }

    @Override
    public boolean recipeMatches(RecipeHolder<RecipeCooking> recipeholder) {
        return recipeholder.value().matches(new SingleRecipeInput(this.container.getItem(0)), this.level);
    }

    @Override
    public int getResultSlotIndex() {
        return 2;
    }

    @Override
    public int getGridWidth() {
        return 1;
    }

    @Override
    public int getGridHeight() {
        return 1;
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 != 1 && i2 != 0 ? (this.canSmelt(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (this.isFuel(itemstack1) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (i2 >= 3 && i2 < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i2 >= 30 && i2 < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmelt(ItemStack itemstack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, new SingleRecipeInput(itemstack), this.level).isPresent();
    }

    protected boolean isFuel(ItemStack itemstack) {
        return TileEntityFurnace.isFuel(itemstack);
    }

    public float getBurnProgress() {
        int i2 = this.data.get(2);
        int j2 = this.data.get(3);
        return j2 != 0 && i2 != 0 ? MathHelper.clamp((float)i2 / (float)j2, 0.0f, 1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i2 = this.data.get(1);
        if (i2 == 0) {
            i2 = 200;
        }
        return MathHelper.clamp((float)this.data.get(0) / (float)i2, 0.0f, 1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    @Override
    public boolean shouldMoveToInventory(int i2) {
        return i2 != 1;
    }
}

