/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ContainerGrindstone
extends Container {
    private CraftInventoryView bukkitEntity = null;
    private Player player;
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final IInventory resultSlots = new InventoryCraftResult();
    final IInventory repairSlots;
    private final ContainerAccess access;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryGrindstone inventory = new CraftInventoryGrindstone(this.repairSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<ContainerGrindstone, CraftInventoryGrindstone>((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerGrindstone(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerGrindstone(int i2, PlayerInventory playerinventory, final ContainerAccess containeraccess) {
        super(Containers.GRINDSTONE, i2);
        int j2;
        this.repairSlots = new InventorySubcontainer(2){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerGrindstone.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.access = containeraccess;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.isDamageableItem() || EnchantmentManager.hasAnyEnchantments(itemstack);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.isDamageableItem() || EnchantmentManager.hasAnyEnchantments(itemstack);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
                containeraccess.execute((world, blockposition) -> {
                    if (world instanceof WorldServer) {
                        EntityExperienceOrb.award((WorldServer)world, Vec3D.atCenterOf(blockposition), this.getExperienceAmount((World)world));
                    }
                    world.levelEvent(1042, (BlockPosition)blockposition, 0);
                });
                ContainerGrindstone.this.repairSlots.setItem(0, ItemStack.EMPTY);
                ContainerGrindstone.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(World world) {
                int j2 = 0;
                j2 += this.getExperienceFromItem(ContainerGrindstone.this.repairSlots.getItem(0));
                if ((j2 += this.getExperienceFromItem(ContainerGrindstone.this.repairSlots.getItem(1))) > 0) {
                    int k2 = (int)Math.ceil((double)j2 / 2.0);
                    return k2 + world.random.nextInt(k2);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack itemstack) {
                int j2 = 0;
                ItemEnchantments itemenchantments = EnchantmentManager.getEnchantmentsForCrafting(itemstack);
                for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    int k2 = entry.getIntValue();
                    if (holder.is(EnchantmentTags.CURSE)) continue;
                    j2 += ((Enchantment)holder.value()).getMinCost(k2);
                }
                return j2;
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        super.slotsChanged(iinventory);
        if (iinventory == this.repairSlots) {
            this.createResult();
        }
    }

    private void createResult() {
        CraftEventFactory.callPrepareGrindstoneEvent(this.getBukkitView(), this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.sendAllDataToRemote();
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack itemstack, ItemStack itemstack1) {
        boolean flag;
        boolean bl = flag = !itemstack.isEmpty() || !itemstack1.isEmpty();
        if (!flag) {
            return ItemStack.EMPTY;
        }
        if (itemstack.getCount() <= 1 && itemstack1.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !itemstack.isEmpty() && !itemstack1.isEmpty();
            if (!flag1) {
                ItemStack itemstack2 = !itemstack.isEmpty() ? itemstack : itemstack1;
                return !EnchantmentManager.hasAnyEnchantments(itemstack2) ? ItemStack.EMPTY : this.removeNonCursesFrom(itemstack2.copy());
            }
            return this.mergeItems(itemstack, itemstack1);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mergeItems(ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2;
        if (!itemstack.is(itemstack1.getItem())) {
            return ItemStack.EMPTY;
        }
        int i2 = Math.max(itemstack.getMaxDamage(), itemstack1.getMaxDamage());
        int j2 = itemstack.getMaxDamage() - itemstack.getDamageValue();
        int k2 = itemstack1.getMaxDamage() - itemstack1.getDamageValue();
        int l2 = j2 + k2 + i2 * 5 / 100;
        int b0 = 1;
        if (!itemstack.isDamageableItem()) {
            if (itemstack.getMaxStackSize() < 2 || !ItemStack.matches(itemstack, itemstack1)) {
                return ItemStack.EMPTY;
            }
            b0 = 2;
        }
        if ((itemstack2 = itemstack.copyWithCount(b0)).isDamageableItem()) {
            itemstack2.set(DataComponents.MAX_DAMAGE, i2);
            itemstack2.setDamageValue(Math.max(i2 - l2, 0));
        }
        this.mergeEnchantsFrom(itemstack2, itemstack1);
        return this.removeNonCursesFrom(itemstack2);
    }

    private void mergeEnchantsFrom(ItemStack itemstack, ItemStack itemstack1) {
        EnchantmentManager.updateEnchantments(itemstack, itemenchantments_a -> {
            ItemEnchantments itemenchantments = EnchantmentManager.getEnchantmentsForCrafting(itemstack1);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && itemenchantments_a.getLevel(holder) != 0) continue;
                itemenchantments_a.upgrade(holder, entry.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack itemstack) {
        ItemEnchantments itemenchantments = EnchantmentManager.updateEnchantments(itemstack, itemenchantments_a -> itemenchantments_a.removeIf(holder -> !holder.is(EnchantmentTags.CURSE)));
        if (itemstack.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            itemstack = itemstack.transmuteCopy(Items.BOOK);
        }
        int i2 = 0;
        for (int j2 = 0; j2 < itemenchantments.size(); ++j2) {
            i2 = ContainerAnvil.calculateIncreasedRepairCost(i2);
        }
        itemstack.set(DataComponents.REPAIR_COST, i2);
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.repairSlots));
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerGrindstone.stillValid(this.access, entityhuman, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.repairSlots.getItem(0);
            ItemStack itemstack3 = this.repairSlots.getItem(1);
            if (i2 == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 != 0 && i2 != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (i2 >= 3 && i2 < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i2 >= 30 && i2 < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }
}

