/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerHopper
extends Container {
    public static final int CONTAINER_SIZE = 5;
    private final IInventory hopper;
    private CraftInventoryView bukkitEntity = null;
    private PlayerInventory player;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = new CraftInventory(this.hopper);
        this.bukkitEntity = new CraftInventoryView<ContainerHopper, CraftInventory>(this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    public ContainerHopper(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, new InventorySubcontainer(5));
    }

    public ContainerHopper(int i2, PlayerInventory playerinventory, IInventory iinventory) {
        super(Containers.HOPPER, i2);
        int j2;
        this.hopper = iinventory;
        this.player = playerinventory;
        ContainerHopper.checkContainerSize(iinventory, 5);
        iinventory.startOpen(playerinventory.player);
        boolean flag = true;
        for (j2 = 0; j2 < 5; ++j2) {
            this.addSlot(new Slot(iinventory, j2, 44 + j2 * 18, 20));
        }
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, j2 * 18 + 51));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 109));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.hopper.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 < this.hopper.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.hopper.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.hopper.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.hopper.stopOpen(entityhuman);
    }
}

