/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class ContainerHorse
extends Container {
    private final IInventory horseContainer;
    private final IInventory armorContainer;
    private final EntityHorseAbstract horse;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;
    CraftInventoryView bukkitEntity;
    PlayerInventory player;

    @Override
    public InventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        this.bukkitEntity = new CraftInventoryView<ContainerHorse, Inventory>(this.player.player.getBukkitEntity(), this.horseContainer.getOwner().getInventory(), this);
        return this.bukkitEntity;
    }

    public ContainerHorse(int i2, PlayerInventory playerinventory, IInventory iinventory, final EntityHorseAbstract entityhorseabstract, int j2) {
        super(null, i2);
        int l2;
        int k2;
        this.player = playerinventory;
        this.horseContainer = iinventory;
        this.armorContainer = entityhorseabstract.getBodyArmorAccess();
        this.horse = entityhorseabstract;
        boolean flag = true;
        iinventory.startOpen(playerinventory.player);
        boolean flag1 = true;
        this.addSlot(new Slot(this, iinventory, 0, 8, 18){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.is(Items.SADDLE) && !this.hasItem() && entityhorseabstract.isSaddleable();
            }

            @Override
            public boolean isActive() {
                return entityhorseabstract.isSaddleable();
            }
        });
        this.addSlot(new ArmorSlot(this, this.armorContainer, entityhorseabstract, EnumItemSlot.BODY, 0, 8, 36, null){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return entityhorseabstract.isBodyArmorItem(itemstack);
            }

            @Override
            public boolean isActive() {
                return entityhorseabstract.canUseSlot(EnumItemSlot.BODY);
            }
        });
        if (j2 > 0) {
            for (k2 = 0; k2 < 3; ++k2) {
                for (l2 = 0; l2 < j2; ++l2) {
                    this.addSlot(new Slot(iinventory, 1 + l2 + k2 * j2, 80 + l2 * 18, 18 + k2 * 18));
                }
            }
        }
        for (k2 = 0; k2 < 3; ++k2) {
            for (l2 = 0; l2 < 9; ++l2) {
                this.addSlot(new Slot(playerinventory, l2 + k2 * 9 + 9, 8 + l2 * 18, 102 + k2 * 18 + -18));
            }
        }
        for (k2 = 0; k2 < 9; ++k2) {
            this.addSlot(new Slot(playerinventory, k2, 8 + k2 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(entityhuman) && this.armorContainer.stillValid(entityhuman) && this.horse.isAlive() && entityhuman.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int j2 = this.horseContainer.getContainerSize() + 1;
            if (i2 < j2) {
                if (!this.moveItemStackTo(itemstack1, j2, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1)) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (j2 <= 1 || !this.moveItemStackTo(itemstack1, 2, j2, false)) {
                int k2 = j2 + 27;
                int l2 = k2 + 9;
                if (i2 >= k2 && i2 < l2 ? !this.moveItemStackTo(itemstack1, j2, k2, false) : (i2 >= j2 && i2 < k2 ? !this.moveItemStackTo(itemstack1, k2, l2, false) : !this.moveItemStackTo(itemstack1, k2, k2, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.horseContainer.stopOpen(entityhuman);
    }
}

