/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftLecternView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;

public class ContainerLectern
extends Container {
    private CraftLecternView bukkitEntity = null;
    private Player player;
    private static final int DATA_COUNT = 1;
    private static final int SLOT_COUNT = 1;
    public static final int BUTTON_PREV_PAGE = 1;
    public static final int BUTTON_NEXT_PAGE = 2;
    public static final int BUTTON_TAKE_BOOK = 3;
    public static final int BUTTON_PAGE_JUMP_RANGE_START = 100;
    private final IInventory lectern;
    private final IContainerProperties lecternData;

    @Override
    public CraftLecternView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLectern inventory = new CraftInventoryLectern(this.lectern);
        this.bukkitEntity = new CraftLecternView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerLectern(int i2, PlayerInventory playerinventory) {
        this(i2, new InventorySubcontainer(1), new ContainerProperties(1), playerinventory);
    }

    public ContainerLectern(int i2, IInventory iinventory, IContainerProperties icontainerproperties, PlayerInventory playerinventory) {
        super(Containers.LECTERN, i2);
        ContainerLectern.checkContainerSize(iinventory, 1);
        ContainerLectern.checkContainerDataCount(icontainerproperties, 1);
        this.lectern = iinventory;
        this.lecternData = icontainerproperties;
        this.addSlot(new Slot(iinventory, 0, 0, 0){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerLectern.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(icontainerproperties);
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean clickMenuButton(EntityHuman entityhuman, int i2) {
        if (i2 >= 100) {
            int j2 = i2 - 100;
            this.setData(0, j2);
            return true;
        }
        switch (i2) {
            case 1: {
                int j3 = this.lecternData.get(0);
                this.setData(0, j3 - 1);
                return true;
            }
            case 2: {
                int j4 = this.lecternData.get(0);
                this.setData(0, j4 + 1);
                return true;
            }
            case 3: {
                if (!entityhuman.mayBuild()) {
                    return false;
                }
                PlayerTakeLecternBookEvent event = new PlayerTakeLecternBookEvent(this.player, ((CraftInventoryLectern)this.getBukkitView().getTopInventory()).getHolder());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return false;
                }
                ItemStack itemstack = this.lectern.removeItemNoUpdate(0);
                this.lectern.setChanged();
                if (!entityhuman.getInventory().add(itemstack)) {
                    entityhuman.drop(itemstack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        return ItemStack.EMPTY;
    }

    @Override
    public void setData(int i2, int j2) {
        super.setData(i2, j2);
        this.broadcastChanges();
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (this.lectern instanceof TileEntityLectern.LecternInventory && !((TileEntityLectern.LecternInventory)this.lectern).getLectern().hasBook()) {
            return false;
        }
        if (!this.checkReachable) {
            return true;
        }
        return this.lectern.stillValid(entityhuman);
    }

    public ItemStack getBook() {
        return this.lectern.getItem(0);
    }

    public int getPage() {
        return this.lecternData.get(0);
    }
}

