/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftLoomView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ContainerLoom
extends Container {
    private CraftLoomView bukkitEntity = null;
    private Player player;
    private static final int PATTERN_NOT_SET = -1;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final ContainerAccess access;
    final ContainerProperty selectedBannerPatternIndex = ContainerProperty.standalone();
    private List<Holder<EnumBannerPatternType>> selectablePatterns = List.of();
    Runnable slotUpdateListener = () -> {};
    private final HolderGetter<EnumBannerPatternType> patternGetter;
    final Slot bannerSlot;
    final Slot dyeSlot;
    private final Slot patternSlot;
    private final Slot resultSlot;
    long lastSoundTime;
    private final IInventory inputContainer;
    private final IInventory outputContainer;

    @Override
    public CraftLoomView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryLoom inventory = new CraftInventoryLoom(this.inputContainer, this.outputContainer);
        this.bukkitEntity = new CraftLoomView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerLoom(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerLoom(int i2, PlayerInventory playerinventory, final ContainerAccess containeraccess) {
        super(Containers.LOOM, i2);
        int j2;
        this.inputContainer = new InventorySubcontainer(3){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerLoom.this.slotsChanged(this);
                ContainerLoom.this.slotUpdateListener.run();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.outputContainer = new InventorySubcontainer(1){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerLoom.this.slotUpdateListener.run();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.access = containeraccess;
        this.bannerSlot = this.addSlot(new Slot(this, this.inputContainer, 0, 13, 26){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.getItem() instanceof ItemBanner;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this, this.inputContainer, 1, 33, 26){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.getItem() instanceof ItemDye;
            }
        });
        this.patternSlot = this.addSlot(new Slot(this, this.inputContainer, 2, 23, 45){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return itemstack.getItem() instanceof ItemBannerPattern;
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 143, 57){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
                ContainerLoom.this.bannerSlot.remove(1);
                ContainerLoom.this.dyeSlot.remove(1);
                if (!ContainerLoom.this.bannerSlot.hasItem() || !ContainerLoom.this.dyeSlot.hasItem()) {
                    ContainerLoom.this.selectedBannerPatternIndex.set(-1);
                }
                containeraccess.execute((world, blockposition) -> {
                    long j2 = world.getGameTime();
                    if (ContainerLoom.this.lastSoundTime != j2) {
                        world.playSound((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.UI_LOOM_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerLoom.this.lastSoundTime = j2;
                    }
                });
                super.onTake(entityhuman, itemstack);
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.addDataSlot(this.selectedBannerPatternIndex);
        this.patternGetter = playerinventory.player.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN);
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerLoom.stillValid(this.access, entityhuman, Blocks.LOOM);
    }

    @Override
    public boolean clickMenuButton(EntityHuman entityhuman, int i2) {
        if (i2 >= 0 && i2 < this.selectablePatterns.size()) {
            this.selectedBannerPatternIndex.set(i2);
            this.setupResultSlot(this.selectablePatterns.get(i2));
            return true;
        }
        return false;
    }

    private List<Holder<EnumBannerPatternType>> getSelectablePatterns(ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return (List)this.patternGetter.get(BannerPatternTags.NO_ITEM_REQUIRED).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        Item item = itemstack.getItem();
        if (item instanceof ItemBannerPattern) {
            ItemBannerPattern itembannerpattern = (ItemBannerPattern)item;
            return (List)this.patternGetter.get(itembannerpattern.getBannerPattern()).map(ImmutableList::copyOf).orElse(ImmutableList.of());
        }
        return List.of();
    }

    private boolean isValidPatternIndex(int i2) {
        return i2 >= 0 && i2 < this.selectablePatterns.size();
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        ItemStack itemstack = this.bannerSlot.getItem();
        ItemStack itemstack1 = this.dyeSlot.getItem();
        ItemStack itemstack2 = this.patternSlot.getItem();
        if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
            Holder<EnumBannerPatternType> holder;
            int i2 = this.selectedBannerPatternIndex.get();
            boolean flag = this.isValidPatternIndex(i2);
            List<Holder<EnumBannerPatternType>> list = this.selectablePatterns;
            this.selectablePatterns = this.getSelectablePatterns(itemstack2);
            if (this.selectablePatterns.size() == 1) {
                this.selectedBannerPatternIndex.set(0);
                holder = this.selectablePatterns.get(0);
            } else if (!flag) {
                this.selectedBannerPatternIndex.set(-1);
                holder = null;
            } else {
                Holder<EnumBannerPatternType> holder1 = list.get(i2);
                int j2 = this.selectablePatterns.indexOf(holder1);
                if (j2 != -1) {
                    holder = holder1;
                    this.selectedBannerPatternIndex.set(j2);
                } else {
                    holder = null;
                    this.selectedBannerPatternIndex.set(-1);
                }
            }
            if (holder != null) {
                boolean flag1;
                BannerPatternLayers bannerpatternlayers = itemstack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY);
                boolean bl = flag1 = bannerpatternlayers.layers().size() >= 6;
                if (flag1) {
                    this.selectedBannerPatternIndex.set(-1);
                    this.resultSlot.set(ItemStack.EMPTY);
                } else {
                    this.setupResultSlot(holder);
                }
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
            this.broadcastChanges();
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
            this.selectablePatterns = List.of();
            this.selectedBannerPatternIndex.set(-1);
        }
    }

    public List<Holder<EnumBannerPatternType>> getSelectablePatterns() {
        return this.selectablePatterns;
    }

    public int getSelectedBannerPatternIndex() {
        return this.selectedBannerPatternIndex.get();
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == this.resultSlot.index) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 != this.dyeSlot.index && i2 != this.bannerSlot.index && i2 != this.patternSlot.index ? (itemstack1.getItem() instanceof ItemBanner ? !this.moveItemStackTo(itemstack1, this.bannerSlot.index, this.bannerSlot.index + 1, false) : (itemstack1.getItem() instanceof ItemDye ? !this.moveItemStackTo(itemstack1, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (itemstack1.getItem() instanceof ItemBannerPattern ? !this.moveItemStackTo(itemstack1, this.patternSlot.index, this.patternSlot.index + 1, false) : (i2 >= 4 && i2 < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : i2 >= 31 && i2 < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.inputContainer));
    }

    private void setupResultSlot(Holder<EnumBannerPatternType> holder) {
        ItemStack itemstack = this.bannerSlot.getItem();
        ItemStack itemstack1 = this.dyeSlot.getItem();
        ItemStack itemstack2 = ItemStack.EMPTY;
        if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
            itemstack2 = itemstack.copyWithCount(1);
            EnumColor enumcolor = ((ItemDye)itemstack1.getItem()).getDyeColor();
            itemstack2.update(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY, bannerpatternlayers -> {
                if (bannerpatternlayers.layers().size() > 20) {
                    bannerpatternlayers = new BannerPatternLayers(List.copyOf(bannerpatternlayers.layers().subList(0, 20)));
                }
                return new BannerPatternLayers.a().addAll((BannerPatternLayers)bannerpatternlayers).add(holder, enumcolor).build();
            });
        }
        if (!ItemStack.matches(itemstack2, this.resultSlot.getItem())) {
            this.resultSlot.set(itemstack2);
        }
    }

    public Slot getBannerSlot() {
        return this.bannerSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

