/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.MerchantWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryMerchant;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotMerchantResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftMerchantView;

public class ContainerMerchant
extends Container {
    protected static final int PAYMENT1_SLOT = 0;
    protected static final int PAYMENT2_SLOT = 1;
    protected static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private static final int SELLSLOT1_X = 136;
    private static final int SELLSLOT2_X = 162;
    private static final int BUYSLOT_X = 220;
    private static final int ROW_Y = 37;
    private final IMerchant trader;
    private final InventoryMerchant tradeContainer;
    private int merchantLevel;
    private boolean showProgressBar;
    private boolean canRestock;
    private CraftMerchantView bukkitEntity = null;
    private PlayerInventory player;

    @Override
    public CraftMerchantView getBukkitView() {
        if (this.bukkitEntity == null) {
            this.bukkitEntity = new CraftMerchantView(this.player.player.getBukkitEntity(), new CraftInventoryMerchant(this.trader, this.tradeContainer), this, this.trader);
        }
        return this.bukkitEntity;
    }

    public ContainerMerchant(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, new MerchantWrapper(playerinventory.player));
    }

    public ContainerMerchant(int i2, PlayerInventory playerinventory, IMerchant imerchant) {
        super(Containers.MERCHANT, i2);
        int j2;
        this.trader = imerchant;
        this.tradeContainer = new InventoryMerchant(imerchant);
        this.addSlot(new Slot(this.tradeContainer, 0, 136, 37));
        this.addSlot(new Slot(this.tradeContainer, 1, 162, 37));
        this.addSlot(new SlotMerchantResult(playerinventory.player, imerchant, this.tradeContainer, 2, 220, 37));
        this.player = playerinventory;
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 108 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 108 + j2 * 18, 142));
        }
    }

    public void setShowProgressBar(boolean flag) {
        this.showProgressBar = flag;
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        this.tradeContainer.updateSellItem();
        super.slotsChanged(iinventory);
    }

    public void setSelectionHint(int i2) {
        this.tradeContainer.setSelectionHint(i2);
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.trader.getTradingPlayer() == entityhuman;
    }

    public int getTraderXp() {
        return this.trader.getVillagerXp();
    }

    public int getFutureTraderXp() {
        return this.tradeContainer.getFutureXp();
    }

    public void setXp(int i2) {
        this.trader.overrideXp(i2);
    }

    public int getTraderLevel() {
        return this.merchantLevel;
    }

    public void setMerchantLevel(int i2) {
        this.merchantLevel = i2;
    }

    public void setCanRestock(boolean flag) {
        this.canRestock = flag;
    }

    public boolean canRestock() {
        return this.canRestock;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return false;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
                this.playTradeSound();
            } else if (i2 != 0 && i2 != 1 ? (i2 >= 3 && i2 < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : i2 >= 30 && i2 < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    private void playTradeSound() {
        if (!this.trader.isClientSide() && this.trader instanceof Entity) {
            Entity entity = (Entity)((Object)this.trader);
            entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), this.trader.getNotifyTradeSound(), SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.trader.setTradingPlayer(null);
        if (!this.trader.isClientSide()) {
            if (!(!entityhuman.isAlive() || entityhuman instanceof EntityPlayer && ((EntityPlayer)entityhuman).hasDisconnected())) {
                if (entityhuman instanceof EntityPlayer) {
                    entityhuman.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(0));
                    entityhuman.getInventory().placeItemBackInInventory(this.tradeContainer.removeItemNoUpdate(1));
                }
            } else {
                ItemStack itemstack = this.tradeContainer.removeItemNoUpdate(0);
                if (!itemstack.isEmpty()) {
                    entityhuman.drop(itemstack, false);
                }
                if (!(itemstack = this.tradeContainer.removeItemNoUpdate(1)).isEmpty()) {
                    entityhuman.drop(itemstack, false);
                }
            }
        }
    }

    public void tryMoveItems(int i2) {
        if (i2 >= 0 && this.getOffers().size() > i2) {
            ItemStack itemstack1;
            ItemStack itemstack = this.tradeContainer.getItem(0);
            if (!itemstack.isEmpty()) {
                if (!this.moveItemStackTo(itemstack, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.setItem(0, itemstack);
            }
            if (!(itemstack1 = this.tradeContainer.getItem(1)).isEmpty()) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.setItem(1, itemstack1);
            }
            if (this.tradeContainer.getItem(0).isEmpty() && this.tradeContainer.getItem(1).isEmpty()) {
                MerchantRecipe merchantrecipe = (MerchantRecipe)this.getOffers().get(i2);
                this.moveFromInventoryToPaymentSlot(0, merchantrecipe.getItemCostA());
                merchantrecipe.getItemCostB().ifPresent(itemcost -> this.moveFromInventoryToPaymentSlot(1, (ItemCost)itemcost));
            }
        }
    }

    private void moveFromInventoryToPaymentSlot(int i2, ItemCost itemcost) {
        for (int j2 = 3; j2 < 39; ++j2) {
            ItemStack itemstack1;
            ItemStack itemstack = ((Slot)this.slots.get(j2)).getItem();
            if (itemstack.isEmpty() || !itemcost.test(itemstack) || !(itemstack1 = this.tradeContainer.getItem(i2)).isEmpty() && !ItemStack.isSameItemSameComponents(itemstack, itemstack1)) continue;
            int k2 = itemstack.getMaxStackSize();
            int l2 = Math.min(k2 - itemstack1.getCount(), itemstack.getCount());
            ItemStack itemstack2 = itemstack.copyWithCount(itemstack1.getCount() + l2);
            itemstack.shrink(l2);
            this.tradeContainer.setItem(i2, itemstack2);
            if (itemstack2.getCount() >= k2) break;
        }
    }

    public void setOffers(MerchantRecipeList merchantrecipelist) {
        this.trader.overrideOffers(merchantrecipelist);
    }

    public MerchantRecipeList getOffers() {
        return this.trader.getOffers();
    }

    public boolean showProgressBar() {
        return this.showProgressBar;
    }
}

