/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerPlayer
extends ContainerRecipeBook<CraftingInput, RecipeCrafting> {
    public static final int CONTAINER_ID = 0;
    public static final int RESULT_SLOT = 0;
    public static final int CRAFT_SLOT_START = 1;
    public static final int CRAFT_SLOT_COUNT = 4;
    public static final int CRAFT_SLOT_END = 5;
    public static final int ARMOR_SLOT_START = 5;
    public static final int ARMOR_SLOT_COUNT = 4;
    public static final int ARMOR_SLOT_END = 9;
    public static final int INV_SLOT_START = 9;
    public static final int INV_SLOT_END = 36;
    public static final int USE_ROW_SLOT_START = 36;
    public static final int USE_ROW_SLOT_END = 45;
    public static final int SHIELD_SLOT = 45;
    public static final MinecraftKey BLOCK_ATLAS = MinecraftKey.withDefaultNamespace("textures/atlas/blocks.png");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_HELMET = MinecraftKey.withDefaultNamespace("item/empty_armor_slot_helmet");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_CHESTPLATE = MinecraftKey.withDefaultNamespace("item/empty_armor_slot_chestplate");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_LEGGINGS = MinecraftKey.withDefaultNamespace("item/empty_armor_slot_leggings");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_BOOTS = MinecraftKey.withDefaultNamespace("item/empty_armor_slot_boots");
    public static final MinecraftKey EMPTY_ARMOR_SLOT_SHIELD = MinecraftKey.withDefaultNamespace("item/empty_armor_slot_shield");
    private static final Map<EnumItemSlot, MinecraftKey> TEXTURE_EMPTY_SLOTS = Map.of(EnumItemSlot.FEET, EMPTY_ARMOR_SLOT_BOOTS, EnumItemSlot.LEGS, EMPTY_ARMOR_SLOT_LEGGINGS, EnumItemSlot.CHEST, EMPTY_ARMOR_SLOT_CHESTPLATE, EnumItemSlot.HEAD, EMPTY_ARMOR_SLOT_HELMET);
    private static final EnumItemSlot[] SLOT_IDS = new EnumItemSlot[]{EnumItemSlot.HEAD, EnumItemSlot.CHEST, EnumItemSlot.LEGS, EnumItemSlot.FEET};
    private final TransientCraftingContainer craftSlots;
    private final InventoryCraftResult resultSlots;
    public final boolean active;
    private final EntityHuman owner;
    private CraftInventoryView bukkitEntity = null;
    private PlayerInventory player;

    public ContainerPlayer(PlayerInventory playerinventory, boolean flag, final EntityHuman entityhuman) {
        super(null, 0);
        int j2;
        int i2;
        this.active = flag;
        this.owner = entityhuman;
        this.resultSlots = new InventoryCraftResult();
        this.craftSlots = new TransientCraftingContainer((Container)this, 2, 2, playerinventory.player);
        this.craftSlots.resultInventory = this.resultSlots;
        this.player = playerinventory;
        this.setTitle(IChatBaseComponent.translatable("container.crafting"));
        this.addSlot(new SlotResult(playerinventory.player, this.craftSlots, this.resultSlots, 0, 154, 28));
        for (i2 = 0; i2 < 2; ++i2) {
            for (j2 = 0; j2 < 2; ++j2) {
                this.addSlot(new Slot(this.craftSlots, j2 + i2 * 2, 98 + j2 * 18, 18 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            EnumItemSlot enumitemslot = SLOT_IDS[i2];
            MinecraftKey minecraftkey = TEXTURE_EMPTY_SLOTS.get(enumitemslot);
            this.addSlot(new ArmorSlot(playerinventory, entityhuman, enumitemslot, 39 - i2, 8, 8 + i2 * 18, minecraftkey));
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j2 = 0; j2 < 9; ++j2) {
                this.addSlot(new Slot(playerinventory, j2 + (i2 + 1) * 9, 8 + j2 * 18, 84 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 9; ++i2) {
            this.addSlot(new Slot(playerinventory, i2, 8 + i2 * 18, 142));
        }
        this.addSlot(new Slot(this, playerinventory, 40, 77, 62){

            @Override
            public void setByPlayer(ItemStack itemstack, ItemStack itemstack1) {
                entityhuman.onEquipItem(EnumItemSlot.OFFHAND, itemstack1, itemstack);
                super.setByPlayer(itemstack, itemstack1);
            }

            @Override
            public Pair<MinecraftKey, MinecraftKey> getNoItemIcon() {
                return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
    }

    public static boolean isHotbarSlot(int i2) {
        return i2 >= 36 && i2 < 45 || i2 == 45;
    }

    @Override
    public void fillCraftSlotsStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        this.craftSlots.fillStackedContents(autorecipestackmanager);
    }

    @Override
    public void clearCraftingContent() {
        this.resultSlots.clearContent();
        this.craftSlots.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder<RecipeCrafting> recipeholder) {
        return recipeholder.value().matches(this.craftSlots.asCraftInput(), this.owner.level());
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        ContainerWorkbench.slotChangedCraftingGrid(this, this.owner.level(), this.owner, this.craftSlots, this.resultSlots, null);
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.resultSlots.clearContent();
        if (!entityhuman.level().isClientSide) {
            this.clearContainer(entityhuman, this.craftSlots);
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return true;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot.hasItem()) {
            int j2;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            EnumItemSlot enumitemslot = entityhuman.getEquipmentSlotForItem(itemstack);
            if (i2 == 0) {
                if (!this.moveItemStackTo(itemstack1, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 >= 1 && i2 < 5 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (i2 >= 5 && i2 < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (enumitemslot.getType() == EnumItemSlot.Function.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - enumitemslot.getIndex())).hasItem() ? !this.moveItemStackTo(itemstack1, j2 = 8 - enumitemslot.getIndex(), j2 + 1, false) : (enumitemslot == EnumItemSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(itemstack1, 45, 46, false) : (i2 >= 9 && i2 < 36 ? !this.moveItemStackTo(itemstack1, 36, 45, false) : (i2 >= 36 && i2 < 45 ? !this.moveItemStackTo(itemstack1, 9, 36, false) : !this.moveItemStackTo(itemstack1, 9, 45, false))))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, itemstack);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            if (i2 == 0) {
                entityhuman.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    @Override
    public int getSize() {
        return 5;
    }

    public InventoryCrafting getCraftSlots() {
        return this.craftSlots;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int i2) {
        return i2 != this.getResultSlotIndex();
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(this.craftSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<ContainerPlayer, CraftInventoryCrafting>(this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

