/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotShulkerBox;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerShulkerBox
extends Container {
    private static final int CONTAINER_SIZE = 27;
    private final IInventory container;
    private CraftInventoryView bukkitEntity;
    private PlayerInventory player;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        this.bukkitEntity = new CraftInventoryView<ContainerShulkerBox, CraftInventory>(this.player.player.getBukkitEntity(), new CraftInventory(this.container), this);
        return this.bukkitEntity;
    }

    public ContainerShulkerBox(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, new InventorySubcontainer(27));
    }

    public ContainerShulkerBox(int i2, PlayerInventory playerinventory, IInventory iinventory) {
        super(Containers.SHULKER_BOX, i2);
        int k2;
        int j2;
        ContainerShulkerBox.checkContainerSize(iinventory, 27);
        this.container = iinventory;
        this.player = playerinventory;
        iinventory.startOpen(playerinventory.player);
        boolean flag = true;
        boolean flag1 = true;
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new SlotShulkerBox(iinventory, k2 + j2 * 9, 8 + k2 * 18, 18 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 < this.container.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.container.stopOpen(entityhuman);
    }
}

