/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerSmithing
extends ContainerAnvilAbstract {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final World level;
    @Nullable
    private RecipeHolder<SmithingRecipe> selectedRecipe;
    private final List<RecipeHolder<SmithingRecipe>> recipes;
    private CraftInventoryView bukkitEntity;

    public ContainerSmithing(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerSmithing(int i2, PlayerInventory playerinventory, ContainerAccess containeraccess) {
        super(Containers.SMITHING, i2, playerinventory, containeraccess);
        this.level = playerinventory.player.level();
        this.recipes = this.level.getRecipeManager().getAllRecipesFor(Recipes.SMITHING);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 8, 48, itemstack -> this.recipes.stream().anyMatch(recipeholder -> ((SmithingRecipe)recipeholder.value()).isTemplateIngredient((ItemStack)itemstack))).withSlot(1, 26, 48, itemstack -> this.recipes.stream().anyMatch(recipeholder -> ((SmithingRecipe)recipeholder.value()).isBaseIngredient((ItemStack)itemstack))).withSlot(2, 44, 48, itemstack -> this.recipes.stream().anyMatch(recipeholder -> ((SmithingRecipe)recipeholder.value()).isAdditionIngredient((ItemStack)itemstack))).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData iblockdata) {
        return iblockdata.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected boolean mayPickup(EntityHuman entityhuman, boolean flag) {
        return this.selectedRecipe != null && this.selectedRecipe.value().matches(this.createRecipeInput(), this.level);
    }

    @Override
    protected void onTake(EntityHuman entityhuman, ItemStack itemstack) {
        itemstack.onCraftedBy(entityhuman.level(), entityhuman, itemstack.getCount());
        this.resultSlots.awardUsedRecipes(entityhuman, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((world, blockposition) -> world.levelEvent(1044, (BlockPosition)blockposition, 0));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private SmithingRecipeInput createRecipeInput() {
        return new SmithingRecipeInput(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2));
    }

    private void shrinkStackInSlot(int i2) {
        ItemStack itemstack = this.inputSlots.getItem(i2);
        if (!itemstack.isEmpty()) {
            itemstack.shrink(1);
            this.inputSlots.setItem(i2, itemstack);
        }
    }

    @Override
    public void createResult() {
        SmithingRecipeInput smithingrecipeinput = this.createRecipeInput();
        List<RecipeHolder<SmithingRecipe>> list = this.level.getRecipeManager().getRecipesFor(Recipes.SMITHING, smithingrecipeinput, this.level);
        if (list.isEmpty()) {
            CraftEventFactory.callPrepareSmithingEvent(this.getBukkitView(), ItemStack.EMPTY);
        } else {
            RecipeHolder<SmithingRecipe> recipeholder = list.get(0);
            ItemStack itemstack = recipeholder.value().assemble(smithingrecipeinput, this.level.registryAccess());
            if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
                this.selectedRecipe = recipeholder;
                this.resultSlots.setRecipeUsed(recipeholder);
                CraftEventFactory.callPrepareSmithingEvent(this.getBukkitView(), itemstack);
            }
        }
    }

    @Override
    public int getSlotToQuickMoveTo(ItemStack itemstack) {
        return this.findSlotToQuickMoveTo(itemstack).orElse(0);
    }

    private static OptionalInt findSlotMatchingIngredient(SmithingRecipe smithingrecipe, ItemStack itemstack) {
        return smithingrecipe.isTemplateIngredient(itemstack) ? OptionalInt.of(0) : (smithingrecipe.isBaseIngredient(itemstack) ? OptionalInt.of(1) : (smithingrecipe.isAdditionIngredient(itemstack) ? OptionalInt.of(2) : OptionalInt.empty()));
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack itemstack) {
        return this.findSlotToQuickMoveTo(itemstack).isPresent();
    }

    private OptionalInt findSlotToQuickMoveTo(ItemStack itemstack) {
        return this.recipes.stream().flatMapToInt(recipeholder -> ContainerSmithing.findSlotMatchingIngredient((SmithingRecipe)recipeholder.value(), itemstack).stream()).filter(i2 -> !this.getSlot(i2).hasItem()).findFirst();
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventorySmithing inventory = new CraftInventorySmithing(this.access.getLocation(), this.inputSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<ContainerSmithing, CraftInventorySmithing>(this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

