/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftStonecutterView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ContainerStonecutter
extends Container {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerAccess access;
    private final ContainerProperty selectedRecipeIndex = ContainerProperty.standalone();
    private final World level;
    private List<RecipeHolder<RecipeStonecutting>> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.EMPTY;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final IInventory container;
    final InventoryCraftResult resultContainer;
    private CraftStonecutterView bukkitEntity = null;
    private Player player;

    @Override
    public CraftStonecutterView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.container, this.resultContainer);
        this.bukkitEntity = new CraftStonecutterView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public ContainerStonecutter(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerStonecutter(int i2, PlayerInventory playerinventory, final ContainerAccess containeraccess) {
        super(Containers.STONECUTTER, i2);
        int j2;
        this.container = new InventorySubcontainer(1){

            @Override
            public void setChanged() {
                super.setChanged();
                ContainerStonecutter.this.slotsChanged(this);
                ContainerStonecutter.this.slotUpdateListener.run();
            }

            @Override
            public Location getLocation() {
                return containeraccess.getLocation();
            }
        };
        this.resultContainer = new InventoryCraftResult();
        this.access = containeraccess;
        this.level = playerinventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot(this.resultContainer, 1, 143, 33){

            @Override
            public boolean mayPlace(ItemStack itemstack) {
                return false;
            }

            @Override
            public void onTake(EntityHuman entityhuman, ItemStack itemstack) {
                itemstack.onCraftedBy(entityhuman.level(), entityhuman, itemstack.getCount());
                ContainerStonecutter.this.resultContainer.awardUsedRecipes(entityhuman, this.getRelevantItems());
                ItemStack itemstack1 = ContainerStonecutter.this.inputSlot.remove(1);
                if (!itemstack1.isEmpty()) {
                    ContainerStonecutter.this.setupResultSlot();
                }
                containeraccess.execute((world, blockposition) -> {
                    long j2 = world.getGameTime();
                    if (ContainerStonecutter.this.lastSoundTime != j2) {
                        world.playSound((EntityHuman)null, (BlockPosition)blockposition, SoundEffects.UI_STONECUTTER_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerStonecutter.this.lastSoundTime = j2;
                    }
                });
                super.onTake(entityhuman, itemstack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(ContainerStonecutter.this.inputSlot.getItem());
            }
        });
        for (j2 = 0; j2 < 3; ++j2) {
            for (int k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
        this.player = (Player)playerinventory.player.getBukkitEntity();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<RecipeStonecutting>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerStonecutter.stillValid(this.access, entityhuman, Blocks.STONECUTTER);
    }

    @Override
    public boolean clickMenuButton(EntityHuman entityhuman, int i2) {
        if (this.isValidRecipeIndex(i2)) {
            this.selectedRecipeIndex.set(i2);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i2) {
        return i2 >= 0 && i2 < this.recipes.size();
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.setupRecipeList(iinventory, itemstack);
        }
    }

    private static SingleRecipeInput createRecipeInput(IInventory iinventory) {
        return new SingleRecipeInput(iinventory.getItem(0));
    }

    private void setupRecipeList(IInventory iinventory, ItemStack itemstack) {
        this.recipes.clear();
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!itemstack.isEmpty()) {
            this.recipes = this.level.getRecipeManager().getRecipesFor(Recipes.STONECUTTING, ContainerStonecutter.createRecipeInput(iinventory), this.level);
        }
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<RecipeStonecutting> recipeholder = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack itemstack = recipeholder.value().assemble(ContainerStonecutter.createRecipeInput(this.container), (HolderLookup.a)this.level.registryAccess());
            if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(recipeholder);
                this.resultSlot.set(itemstack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @Override
    public Containers<?> getType() {
        return Containers.STONECUTTER;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 1) {
                item.onCraftedBy(itemstack1, entityhuman.level(), entityhuman);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (this.level.getRecipeManager().getRecipeFor(Recipes.STONECUTTING, new SingleRecipeInput(itemstack1), this.level).isPresent() ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i2 >= 2 && i2 < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : i2 >= 29 && i2 < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.container));
    }
}

