/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeRepair;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;

public class ContainerWorkbench
extends ContainerRecipeBook<CraftingInput, RecipeCrafting> {
    public static final int RESULT_SLOT = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_END = 10;
    private static final int INV_SLOT_START = 10;
    private static final int INV_SLOT_END = 37;
    private static final int USE_ROW_SLOT_START = 37;
    private static final int USE_ROW_SLOT_END = 46;
    public final TransientCraftingContainer craftSlots;
    public final InventoryCraftResult resultSlots = new InventoryCraftResult();
    public final ContainerAccess access;
    private final EntityHuman player;
    private boolean placingRecipe;
    private CraftInventoryView bukkitEntity = null;

    public ContainerWorkbench(int i2, PlayerInventory playerinventory) {
        this(i2, playerinventory, ContainerAccess.NULL);
    }

    public ContainerWorkbench(int i2, PlayerInventory playerinventory, ContainerAccess containeraccess) {
        super(Containers.CRAFTING, i2);
        int k2;
        int j2;
        this.craftSlots = new TransientCraftingContainer((Container)this, 3, 3, playerinventory.player);
        this.craftSlots.resultInventory = this.resultSlots;
        this.access = containeraccess;
        this.player = playerinventory.player;
        this.addSlot(new SlotResult(playerinventory.player, this.craftSlots, this.resultSlots, 0, 124, 35));
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 3; ++k2) {
                this.addSlot(new Slot(this.craftSlots, k2 + j2 * 3, 30 + k2 * 18, 17 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 3; ++j2) {
            for (k2 = 0; k2 < 9; ++k2) {
                this.addSlot(new Slot(playerinventory, k2 + j2 * 9 + 9, 8 + k2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
    }

    protected static void slotChangedCraftingGrid(Container container, World world, EntityHuman entityhuman, InventoryCrafting inventorycrafting, InventoryCraftResult inventorycraftresult, @Nullable RecipeHolder<RecipeCrafting> recipeholder) {
        if (!world.isClientSide) {
            CraftingInput craftinginput = inventorycrafting.asCraftInput();
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional<RecipeHolder<RecipeCrafting>> optional = world.getServer().getRecipeManager().getRecipeFor(Recipes.CRAFTING, craftinginput, world, recipeholder);
            inventorycrafting.setCurrentRecipe(optional.orElse(null));
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder<RecipeCrafting> recipeholder1 = optional.get();
                RecipeCrafting recipecrafting = recipeholder1.value();
                if (inventorycraftresult.setRecipeUsed(world, entityplayer, recipeholder1) && (itemstack1 = recipecrafting.assemble(craftinginput, world.registryAccess())).isItemEnabled(world.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            itemstack = CraftEventFactory.callPreCraftEvent(inventorycrafting, inventorycraftresult, itemstack, container.getBukkitView(), optional.map(RecipeHolder::value).orElse(null) instanceof RecipeRepair);
            inventorycraftresult.setItem(0, itemstack);
            container.setRemoteSlot(0, itemstack);
            entityplayer.connection.send(new PacketPlayOutSetSlot(container.containerId, container.incrementStateId(), 0, itemstack));
        }
    }

    @Override
    public void slotsChanged(IInventory iinventory) {
        if (!this.placingRecipe) {
            this.access.execute((world, blockposition) -> ContainerWorkbench.slotChangedCraftingGrid(this, world, this.player, this.craftSlots, this.resultSlots, null));
        }
    }

    @Override
    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    @Override
    public void finishPlacingRecipe(RecipeHolder<RecipeCrafting> recipeholder) {
        this.placingRecipe = false;
        this.access.execute((world, blockposition) -> ContainerWorkbench.slotChangedCraftingGrid(this, world, this.player, this.craftSlots, this.resultSlots, recipeholder));
    }

    @Override
    public void fillCraftSlotsStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        this.craftSlots.fillStackedContents(autorecipestackmanager);
    }

    @Override
    public void clearCraftingContent() {
        this.craftSlots.clearContent();
        this.resultSlots.clearContent();
    }

    @Override
    public boolean recipeMatches(RecipeHolder<RecipeCrafting> recipeholder) {
        return recipeholder.value().matches(this.craftSlots.asCraftInput(), this.player.level());
    }

    @Override
    public void removed(EntityHuman entityhuman) {
        super.removed(entityhuman);
        this.access.execute((world, blockposition) -> this.clearContainer(entityhuman, this.craftSlots));
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return ContainerWorkbench.stillValid(this.access, entityhuman, Blocks.CRAFTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 == 0) {
                this.access.execute((world, blockposition) -> itemstack1.getItem().onCraftedBy(itemstack1, (World)world, entityhuman));
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (i2 >= 10 && i2 < 46 ? !this.moveItemStackTo(itemstack1, 1, 10, false) && (i2 < 37 ? !this.moveItemStackTo(itemstack1, 37, 46, false) : !this.moveItemStackTo(itemstack1, 10, 37, false)) : !this.moveItemStackTo(itemstack1, 10, 46, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
            if (i2 == 0) {
                entityhuman.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack itemstack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(itemstack, slot);
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    @Override
    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int i2) {
        return i2 != this.getResultSlotIndex();
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(this.craftSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<ContainerWorkbench, CraftInventoryCrafting>(this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

