/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.CrafterSlot;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.NonInteractiveResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.CrafterBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCrafter;
import org.bukkit.craftbukkit.v1_21_R1.inventory.view.CraftCrafterView;
import org.bukkit.entity.HumanEntity;

public class CrafterMenu
extends Container
implements ICrafting {
    private CraftCrafterView bukkitEntity = null;
    protected static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    private final InventoryCraftResult resultContainer = new InventoryCraftResult();
    private final IContainerProperties containerData;
    private final EntityHuman player;
    private final InventoryCrafting container;

    @Override
    public CraftCrafterView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryCrafter inventory = new CraftInventoryCrafter(this.container, this.resultContainer);
        this.bukkitEntity = new CraftCrafterView((HumanEntity)this.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    public CrafterMenu(int i2, PlayerInventory playerinventory) {
        super(Containers.CRAFTER_3x3, i2);
        this.player = playerinventory.player;
        this.containerData = new ContainerProperties(10);
        this.container = new TransientCraftingContainer(this, 3, 3);
        this.addSlots(playerinventory);
    }

    public CrafterMenu(int i2, PlayerInventory playerinventory, InventoryCrafting inventorycrafting, IContainerProperties icontainerproperties) {
        super(Containers.CRAFTER_3x3, i2);
        this.player = playerinventory.player;
        this.containerData = icontainerproperties;
        this.container = inventorycrafting;
        CrafterMenu.checkContainerSize(inventorycrafting, 9);
        inventorycrafting.startOpen(playerinventory.player);
        this.addSlots(playerinventory);
        this.addSlotListener(this);
    }

    private void addSlots(PlayerInventory playerinventory) {
        int i2;
        int j2;
        for (j2 = 0; j2 < 3; ++j2) {
            for (i2 = 0; i2 < 3; ++i2) {
                int k2 = i2 + j2 * 3;
                this.addSlot(new CrafterSlot(this.container, k2, 26 + i2 * 18, 17 + j2 * 18, this));
            }
        }
        for (j2 = 0; j2 < 3; ++j2) {
            for (i2 = 0; i2 < 9; ++i2) {
                this.addSlot(new Slot(playerinventory, i2 + j2 * 9 + 9, 8 + i2 * 18, 84 + j2 * 18));
            }
        }
        for (j2 = 0; j2 < 9; ++j2) {
            this.addSlot(new Slot(playerinventory, j2, 8 + j2 * 18, 142));
        }
        this.addSlot(new NonInteractiveResultSlot(this.resultContainer, 0, 134, 35));
        this.addDataSlots(this.containerData);
        this.refreshRecipeResult();
    }

    public void setSlotState(int i2, boolean flag) {
        CrafterSlot crafterslot = (CrafterSlot)this.getSlot(i2);
        this.containerData.set(crafterslot.index, flag ? 0 : 1);
        this.broadcastChanges();
    }

    public boolean isSlotDisabled(int i2) {
        return i2 > -1 && i2 < 9 ? this.containerData.get(i2) == 1 : false;
    }

    public boolean isPowered() {
        return this.containerData.get(9) == 1;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman entityhuman, int i2) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i2 < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, true) : !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.container.stillValid(entityhuman);
    }

    private void refreshRecipeResult() {
        EntityHuman entityhuman = this.player;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            World world = entityplayer.level();
            CraftingInput craftinginput = this.container.asCraftInput();
            ItemStack itemstack = CrafterBlock.getPotentialResults(world, craftinginput).map(recipeholder -> ((RecipeCrafting)recipeholder.value()).assemble(craftinginput, world.registryAccess())).orElse(ItemStack.EMPTY);
            this.resultContainer.setItem(0, itemstack);
        }
    }

    public IInventory getContainer() {
        return this.container;
    }

    @Override
    public void slotChanged(Container container, int i2, ItemStack itemstack) {
        this.refreshRecipeResult();
    }

    @Override
    public void dataChanged(Container container, int i2, int j2) {
    }
}

