/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.inventory.InventoryHolder;

public class InventoryEnderChest
extends InventorySubcontainer {
    @Nullable
    private TileEntityEnderChest activeChest;
    private final EntityHuman owner;

    public InventoryHolder getBukkitOwner() {
        return this.owner.getBukkitEntity();
    }

    @Override
    public Location getLocation() {
        return this.activeChest != null ? CraftLocation.toBukkit(this.activeChest.getBlockPos(), (World)this.activeChest.getLevel().getWorld()) : null;
    }

    public InventoryEnderChest(EntityHuman owner) {
        super(27);
        this.owner = owner;
    }

    public void setActiveChest(TileEntityEnderChest tileentityenderchest) {
        this.activeChest = tileentityenderchest;
    }

    public boolean isActiveChest(TileEntityEnderChest tileentityenderchest) {
        return this.activeChest == tileentityenderchest;
    }

    @Override
    public void fromTag(NBTTagList nbttaglist, HolderLookup.a holderlookup_a) {
        int i2;
        for (i2 = 0; i2 < this.getContainerSize(); ++i2) {
            this.setItem(i2, ItemStack.EMPTY);
        }
        for (i2 = 0; i2 < nbttaglist.size(); ++i2) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompound(i2);
            int j2 = nbttagcompound.getByte("Slot") & 0xFF;
            if (j2 < 0 || j2 >= this.getContainerSize()) continue;
            this.setItem(j2, ItemStack.parse(holderlookup_a, nbttagcompound).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public NBTTagList createTag(HolderLookup.a holderlookup_a) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
            ItemStack itemstack = this.getItem(i2);
            if (itemstack.isEmpty()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.putByte("Slot", (byte)i2);
            nbttaglist.add(itemstack.save(holderlookup_a, nbttagcompound));
        }
        return nbttaglist;
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.activeChest != null && !this.activeChest.stillValid(entityhuman) ? false : super.stillValid(entityhuman);
    }

    @Override
    public void startOpen(EntityHuman entityhuman) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(entityhuman);
        }
        super.startOpen(entityhuman);
    }

    @Override
    public void stopOpen(EntityHuman entityhuman) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(entityhuman);
        }
        super.stopOpen(entityhuman);
        this.activeChest = null;
    }
}

