/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class InventoryMerchant
implements IInventory {
    private final IMerchant merchant;
    private final NonNullList<ItemStack> itemStacks;
    @Nullable
    private MerchantRecipe activeOffer;
    public int selectionHint;
    private int futureXp;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.itemStacks;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
        this.merchant.setTradingPlayer(null);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i2) {
        this.maxStack = i2;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.merchant instanceof EntityVillagerAbstract ? (CraftAbstractVillager)((EntityVillagerAbstract)this.merchant).getBukkitEntity() : null;
    }

    @Override
    public Location getLocation() {
        return this.merchant instanceof EntityVillager ? ((EntityVillager)this.merchant).getBukkitEntity().getLocation() : null;
    }

    public InventoryMerchant(IMerchant imerchant) {
        this.itemStacks = NonNullList.withSize(3, ItemStack.EMPTY);
        this.merchant = imerchant;
    }

    @Override
    public int getContainerSize() {
        return this.itemStacks.size();
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.itemStacks.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public ItemStack getItem(int i2) {
        return this.itemStacks.get(i2);
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        ItemStack itemstack = this.itemStacks.get(i2);
        if (i2 == 2 && !itemstack.isEmpty()) {
            return ContainerUtil.removeItem(this.itemStacks, i2, itemstack.getCount());
        }
        ItemStack itemstack1 = ContainerUtil.removeItem(this.itemStacks, i2, j2);
        if (!itemstack1.isEmpty() && this.isPaymentSlot(i2)) {
            this.updateSellItem();
        }
        return itemstack1;
    }

    private boolean isPaymentSlot(int i2) {
        return i2 == 0 || i2 == 1;
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        return ContainerUtil.takeItem(this.itemStacks, i2);
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        this.itemStacks.set(i2, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
        if (this.isPaymentSlot(i2)) {
            this.updateSellItem();
        }
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return this.merchant.getTradingPlayer() == entityhuman;
    }

    @Override
    public void setChanged() {
        this.updateSellItem();
    }

    public void updateSellItem() {
        ItemStack itemstack1;
        ItemStack itemstack;
        this.activeOffer = null;
        if (this.itemStacks.get(0).isEmpty()) {
            itemstack = this.itemStacks.get(1);
            itemstack1 = ItemStack.EMPTY;
        } else {
            itemstack = this.itemStacks.get(0);
            itemstack1 = this.itemStacks.get(1);
        }
        if (itemstack.isEmpty()) {
            this.setItem(2, ItemStack.EMPTY);
            this.futureXp = 0;
        } else {
            MerchantRecipeList merchantrecipelist = this.merchant.getOffers();
            if (!merchantrecipelist.isEmpty()) {
                MerchantRecipe merchantrecipe = merchantrecipelist.getRecipeFor(itemstack, itemstack1, this.selectionHint);
                if (merchantrecipe == null || merchantrecipe.isOutOfStock()) {
                    this.activeOffer = merchantrecipe;
                    merchantrecipe = merchantrecipelist.getRecipeFor(itemstack1, itemstack, this.selectionHint);
                }
                if (merchantrecipe != null && !merchantrecipe.isOutOfStock()) {
                    this.activeOffer = merchantrecipe;
                    this.setItem(2, merchantrecipe.assemble());
                    this.futureXp = merchantrecipe.getXp();
                } else {
                    this.setItem(2, ItemStack.EMPTY);
                    this.futureXp = 0;
                }
            }
            this.merchant.notifyTradeUpdated(this.getItem(2));
        }
    }

    @Nullable
    public MerchantRecipe getActiveOffer() {
        return this.activeOffer;
    }

    public void setSelectionHint(int i2) {
        this.selectionHint = i2;
        this.updateSellItem();
    }

    @Override
    public void clearContent() {
        this.itemStacks.clear();
    }

    public int getFutureXp() {
        return this.futureXp;
    }
}

