/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class Slot {
    public final int slot;
    public final IInventory container;
    public int index;
    public final int x;
    public final int y;

    public Slot(IInventory var0, int var1, int var2, int var3) {
        this.container = var0;
        this.slot = var1;
        this.x = var2;
        this.y = var3;
    }

    public void onQuickCraft(ItemStack var0, ItemStack var1) {
        int var2 = var1.getCount() - var0.getCount();
        if (var2 > 0) {
            this.onQuickCraft(var1, var2);
        }
    }

    protected void onQuickCraft(ItemStack var0, int var1) {
    }

    protected void onSwapCraft(int var0) {
    }

    protected void checkTakeAchievements(ItemStack var0) {
    }

    public void onTake(EntityHuman var0, ItemStack var1) {
        this.setChanged();
    }

    public boolean mayPlace(ItemStack var0) {
        return true;
    }

    public ItemStack getItem() {
        return this.container.getItem(this.slot);
    }

    public boolean hasItem() {
        return !this.getItem().isEmpty();
    }

    public void setByPlayer(ItemStack var0) {
        this.setByPlayer(var0, this.getItem());
    }

    public void setByPlayer(ItemStack var0, ItemStack var1) {
        this.set(var0);
    }

    public void set(ItemStack var0) {
        this.container.setItem(this.slot, var0);
        this.setChanged();
    }

    public void setChanged() {
        this.container.setChanged();
    }

    public int getMaxStackSize() {
        return this.container.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack var0) {
        return Math.min(this.getMaxStackSize(), var0.getMaxStackSize());
    }

    @Nullable
    public Pair<MinecraftKey, MinecraftKey> getNoItemIcon() {
        return null;
    }

    public ItemStack remove(int var0) {
        return this.container.removeItem(this.slot, var0);
    }

    public boolean mayPickup(EntityHuman var0) {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public Optional<ItemStack> tryRemove(int var0, int var1, EntityHuman var2) {
        if (!this.mayPickup(var2)) {
            return Optional.empty();
        }
        if (!this.allowModification(var2) && var1 < this.getItem().getCount()) {
            return Optional.empty();
        }
        ItemStack var3 = this.remove(var0 = Math.min(var0, var1));
        if (var3.isEmpty()) {
            return Optional.empty();
        }
        if (this.getItem().isEmpty()) {
            this.setByPlayer(ItemStack.EMPTY, var3);
        }
        return Optional.of(var3);
    }

    public ItemStack safeTake(int var0, int var12, EntityHuman var2) {
        Optional<ItemStack> var3 = this.tryRemove(var0, var12, var2);
        var3.ifPresent(var1 -> this.onTake(var2, (ItemStack)var1));
        return var3.orElse(ItemStack.EMPTY);
    }

    public ItemStack safeInsert(ItemStack var0) {
        return this.safeInsert(var0, var0.getCount());
    }

    public ItemStack safeInsert(ItemStack var0, int var1) {
        if (var0.isEmpty() || !this.mayPlace(var0)) {
            return var0;
        }
        ItemStack var2 = this.getItem();
        int var3 = Math.min(Math.min(var1, var0.getCount()), this.getMaxStackSize(var0) - var2.getCount());
        if (var2.isEmpty()) {
            this.setByPlayer(var0.split(var3));
        } else if (ItemStack.isSameItemSameComponents(var2, var0)) {
            var0.shrink(var3);
            var2.grow(var3);
            this.setByPlayer(var2);
        }
        return var0;
    }

    public boolean allowModification(EntityHuman var0) {
        return this.mayPickup(var0) && this.mayPlace(this.getItem());
    }

    public int getContainerSlot() {
        return this.slot;
    }

    public boolean isHighlightable() {
        return true;
    }

    public boolean isFake() {
        return false;
    }
}

