/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class TransientCraftingContainer
implements InventoryCrafting {
    private final NonNullList<ItemStack> items;
    private final int width;
    private final int height;
    private final Container menu;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private RecipeHolder<?> currentRecipe;
    public IInventory resultInventory;
    private EntityHuman owner;
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    public InventoryType getInvType() {
        return this.items.size() == 4 ? InventoryType.CRAFTING : InventoryType.WORKBENCH;
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.owner == null ? null : this.owner.getBukkitEntity();
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
        this.resultInventory.setMaxStackSize(size);
    }

    @Override
    public Location getLocation() {
        return this.menu instanceof ContainerWorkbench ? ((ContainerWorkbench)this.menu).access.getLocation() : this.owner.getBukkitEntity().getLocation();
    }

    @Override
    public RecipeHolder<?> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(RecipeHolder<?> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public TransientCraftingContainer(Container container, int i2, int j2, EntityHuman player) {
        this(container, i2, j2);
        this.owner = player;
    }

    public TransientCraftingContainer(Container container, int i2, int j2) {
        this(container, i2, j2, NonNullList.withSize(i2 * j2, ItemStack.EMPTY));
    }

    public TransientCraftingContainer(Container container, int i2, int j2, NonNullList<ItemStack> nonnulllist) {
        this.items = nonnulllist;
        this.menu = container;
        this.width = i2;
        this.height = j2;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public ItemStack getItem(int i2) {
        return i2 >= this.getContainerSize() ? ItemStack.EMPTY : this.items.get(i2);
    }

    @Override
    public ItemStack removeItemNoUpdate(int i2) {
        return ContainerUtil.takeItem(this.items, i2);
    }

    @Override
    public ItemStack removeItem(int i2, int j2) {
        ItemStack itemstack = ContainerUtil.removeItem(this.items, i2, j2);
        if (!itemstack.isEmpty()) {
            this.menu.slotsChanged(this);
        }
        return itemstack;
    }

    @Override
    public void setItem(int i2, ItemStack itemstack) {
        this.items.set(i2, itemstack);
        this.menu.slotsChanged(this);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman entityhuman) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public List<ItemStack> getItems() {
        return List.copyOf(this.items);
    }

    @Override
    public void fillStackedContents(AutoRecipeStackManager autorecipestackmanager) {
        for (ItemStack itemstack : this.items) {
            autorecipestackmanager.accountSimpleStack(itemstack);
        }
    }
}

