/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.INamable;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;

public class ItemArmor
extends Item
implements Equipable {
    public static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){

        @Override
        protected ItemStack execute(SourceBlock sourceblock, ItemStack itemstack) {
            return ItemArmor.dispenseArmor(sourceblock, itemstack) ? itemstack : super.execute(sourceblock, itemstack);
        }
    };
    protected final a type;
    protected final Holder<ArmorMaterial> material;
    private final Supplier<ItemAttributeModifiers> defaultModifiers;

    public static boolean dispenseArmor(SourceBlock sourceblock, ItemStack itemstack) {
        BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
        List<Entity> list = sourceblock.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(blockposition), IEntitySelector.NO_SPECTATORS.and(new IEntitySelector.EntitySelectorEquipable(itemstack)));
        if (list.isEmpty()) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)list.get(0);
        EnumItemSlot enumitemslot = entityliving.getEquipmentSlotForItem(itemstack);
        ItemStack itemstack1 = itemstack.split(1);
        WorldServer world = sourceblock.level();
        CraftBlock block = CraftBlock.at(world, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (org.bukkit.inventory.ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityliving.getBukkitEntity()));
        if (!BlockDispenser.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return false;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != IDispenseBehavior.NOOP && idispensebehavior != DISPENSE_ITEM_BEHAVIOR) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return true;
            }
        }
        entityliving.setItemSlot(enumitemslot, CraftItemStack.asNMSCopy(event.getItem()));
        if (entityliving instanceof EntityInsentient) {
            ((EntityInsentient)entityliving).setDropChance(enumitemslot, 2.0f);
            ((EntityInsentient)entityliving).setPersistenceRequired();
        }
        return true;
    }

    public ItemArmor(Holder<ArmorMaterial> holder, a itemarmor_a, Item.Info item_info) {
        super(item_info);
        this.material = holder;
        this.type = itemarmor_a;
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
        this.defaultModifiers = Suppliers.memoize(() -> {
            int i2 = ((ArmorMaterial)holder.value()).getDefense(itemarmor_a);
            float f2 = ((ArmorMaterial)holder.value()).toughness();
            ItemAttributeModifiers.a itemattributemodifiers_a = ItemAttributeModifiers.builder();
            EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot(itemarmor_a.getSlot());
            MinecraftKey minecraftkey = MinecraftKey.withDefaultNamespace("armor." + itemarmor_a.getName());
            itemattributemodifiers_a.add(GenericAttributes.ARMOR, new AttributeModifier(minecraftkey, i2, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            itemattributemodifiers_a.add(GenericAttributes.ARMOR_TOUGHNESS, new AttributeModifier(minecraftkey, f2, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            float f1 = ((ArmorMaterial)holder.value()).knockbackResistance();
            if (f1 > 0.0f) {
                itemattributemodifiers_a.add(GenericAttributes.KNOCKBACK_RESISTANCE, new AttributeModifier(minecraftkey, f1, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
            }
            return itemattributemodifiers_a.build();
        });
    }

    public a getType() {
        return this.type;
    }

    @Override
    public int getEnchantmentValue() {
        return this.material.value().enchantmentValue();
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    @Override
    public boolean isValidRepairItem(ItemStack itemstack, ItemStack itemstack1) {
        return this.material.value().repairIngredient().get().test(itemstack1) || super.isValidRepairItem(itemstack, itemstack1);
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        return this.swapWithEquipmentSlot(this, world, entityhuman, enumhand);
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public int getDefense() {
        return this.material.value().getDefense(this.type);
    }

    public float getToughness() {
        return this.material.value().toughness();
    }

    @Override
    public EnumItemSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    @Override
    public Holder<SoundEffect> getEquipSound() {
        return this.getMaterial().value().equipSound();
    }

    public static enum a implements INamable
    {
        HELMET(EnumItemSlot.HEAD, 11, "helmet"),
        CHESTPLATE(EnumItemSlot.CHEST, 16, "chestplate"),
        LEGGINGS(EnumItemSlot.LEGS, 15, "leggings"),
        BOOTS(EnumItemSlot.FEET, 13, "boots"),
        BODY(EnumItemSlot.BODY, 16, "body");

        public static final Codec<a> CODEC;
        private final EnumItemSlot slot;
        private final String name;
        private final int durability;

        private a(EnumItemSlot enumitemslot, int i2, String s2) {
            this.slot = enumitemslot;
            this.name = s2;
            this.durability = i2;
        }

        public int getDurability(int i2) {
            return this.durability * i2;
        }

        public EnumItemSlot getSlot() {
            return this.slot;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTrims() {
            return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = INamable.fromValues(a::values);
        }
    }
}

