/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;

public class ItemBlockWallable
extends ItemBlock {
    public final net.minecraft.world.level.block.Block wallBlock;
    private final EnumDirection attachmentDirection;

    public ItemBlockWallable(net.minecraft.world.level.block.Block block, net.minecraft.world.level.block.Block block1, Item.Info item_info, EnumDirection enumdirection) {
        super(block, item_info);
        this.wallBlock = block1;
        this.attachmentDirection = enumdirection;
    }

    protected boolean canPlace(IWorldReader iworldreader, IBlockData iblockdata, BlockPosition blockposition) {
        return iblockdata.canSurvive(iworldreader, blockposition);
    }

    @Override
    @Nullable
    protected IBlockData getPlacementState(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = this.wallBlock.getStateForPlacement(blockactioncontext);
        IBlockData iblockdata1 = null;
        World world = blockactioncontext.getLevel();
        BlockPosition blockposition = blockactioncontext.getClickedPos();
        for (EnumDirection enumdirection : blockactioncontext.getNearestLookingDirections()) {
            IBlockData iblockdata2;
            if (enumdirection == this.attachmentDirection.getOpposite()) continue;
            IBlockData iBlockData = iblockdata2 = enumdirection == this.attachmentDirection ? this.getBlock().getStateForPlacement(blockactioncontext) : iblockdata;
            if (iblockdata2 == null || !this.canPlace(world, iblockdata2, blockposition)) continue;
            iblockdata1 = iblockdata2;
            break;
        }
        if (iblockdata1 != null) {
            boolean defaultReturn = world.isUnobstructed(iblockdata1, blockposition, VoxelShapeCollision.empty());
            Player player = blockactioncontext.getPlayer() instanceof EntityPlayer ? (Player)blockactioncontext.getPlayer().getBukkitEntity() : null;
            BlockCanBuildEvent event = new BlockCanBuildEvent((Block)CraftBlock.at(world, blockposition), player, (BlockData)CraftBlockData.fromData(iblockdata1), defaultReturn);
            blockactioncontext.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
            return event.isBuildable() ? iblockdata1 : null;
        }
        return null;
    }

    @Override
    public void registerBlocks(Map<net.minecraft.world.level.block.Block, Item> map, Item item) {
        super.registerBlocks(map, item);
        map.put(this.wallBlock, item);
    }
}

