/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ItemBoat
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = IEntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final EntityBoat.EnumBoatType type;
    private final boolean hasChest;

    public ItemBoat(boolean flag, EntityBoat.EnumBoatType entityboat_enumboattype, Item.Info item_info) {
        super(item_info);
        this.hasChest = flag;
        this.type = entityboat_enumboattype;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemBoat.getPlayerPOVHitResult(world, entityhuman, RayTrace.FluidCollisionOption.ANY);
        if (movingobjectpositionblock.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return InteractionResultWrapper.pass(itemstack);
        }
        Vec3D vec3d = entityhuman.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = world.getEntities(entityhuman, entityhuman.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3D vec3d1 = entityhuman.getEyePosition();
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!axisalignedbb.contains(vec3d1)) continue;
                return InteractionResultWrapper.pass(itemstack);
            }
        }
        if (movingobjectpositionblock.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(entityhuman, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, false, enumhand, movingobjectpositionblock.getLocation());
            if (event.isCancelled()) {
                return InteractionResultWrapper.pass(itemstack);
            }
            EntityBoat entityboat = this.getBoat(world, movingobjectpositionblock, itemstack, entityhuman);
            entityboat.setVariant(this.type);
            entityboat.setYRot(entityhuman.getYRot());
            if (!world.noCollision(entityboat, entityboat.getBoundingBox())) {
                return InteractionResultWrapper.fail(itemstack);
            }
            if (!world.isClientSide) {
                if (CraftEventFactory.callEntityPlaceEvent(world, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), entityhuman, entityboat, enumhand).isCancelled()) {
                    return InteractionResultWrapper.fail(itemstack);
                }
                if (!world.addFreshEntity(entityboat)) {
                    return InteractionResultWrapper.pass(itemstack);
                }
                world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, movingobjectpositionblock.getLocation());
                itemstack.consume(1, entityhuman);
            }
            entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.sidedSuccess(itemstack, world.isClientSide());
        }
        return InteractionResultWrapper.pass(itemstack);
    }

    private EntityBoat getBoat(World world, MovingObjectPosition movingobjectposition, ItemStack itemstack, EntityHuman entityhuman) {
        EntityBoat object;
        Vec3D vec3d = movingobjectposition.getLocation();
        EntityBoat entityBoat = object = this.hasChest ? new ChestBoat(world, vec3d.x, vec3d.y, vec3d.z) : new EntityBoat(world, vec3d.x, vec3d.y, vec3d.z);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityTypes.createDefaultStackConfig(worldserver, itemstack, entityhuman).accept((ChestBoat)object);
        }
        return object;
    }
}

