/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemBoneMeal
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public ItemBoneMeal(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        return ItemBoneMeal.applyBonemeal(itemactioncontext);
    }

    public static EnumInteractionResult applyBonemeal(ItemActionContext itemactioncontext) {
        World world = itemactioncontext.getLevel();
        BlockPosition blockposition = itemactioncontext.getClickedPos();
        BlockPosition blockposition1 = blockposition.relative(itemactioncontext.getClickedFace());
        if (ItemBoneMeal.growCrop(itemactioncontext.getItemInHand(), world, blockposition)) {
            if (!world.isClientSide) {
                if (itemactioncontext.getPlayer() != null) {
                    itemactioncontext.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                }
                world.levelEvent(1505, blockposition, 15);
            }
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        IBlockData iblockdata = world.getBlockState(blockposition);
        boolean flag = iblockdata.isFaceSturdy(world, blockposition, itemactioncontext.getClickedFace());
        if (flag && ItemBoneMeal.growWaterPlant(itemactioncontext.getItemInHand(), world, blockposition1, itemactioncontext.getClickedFace())) {
            if (!world.isClientSide) {
                if (itemactioncontext.getPlayer() != null) {
                    itemactioncontext.getPlayer().gameEvent(GameEvent.ITEM_INTERACT_FINISH);
                }
                world.levelEvent(1505, blockposition1, 15);
            }
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean growCrop(ItemStack itemstack, World world, BlockPosition blockposition) {
        IBlockFragilePlantElement iblockfragileplantelement;
        IBlockData iblockdata = world.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof IBlockFragilePlantElement && (iblockfragileplantelement = (IBlockFragilePlantElement)((Object)block)).isValidBonemealTarget(world, blockposition, iblockdata)) {
            if (world instanceof WorldServer) {
                if (iblockfragileplantelement.isBonemealSuccess(world, world.random, blockposition, iblockdata)) {
                    iblockfragileplantelement.performBonemeal((WorldServer)world, world.random, blockposition, iblockdata);
                }
                itemstack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack itemstack, World world, BlockPosition blockposition, @Nullable EnumDirection enumdirection) {
        if (world.getBlockState(blockposition).is(Blocks.WATER) && world.getFluidState(blockposition).getAmount() == 8) {
            if (!(world instanceof WorldServer)) {
                return true;
            }
            RandomSource randomsource = world.getRandom();
            block0: for (int i2 = 0; i2 < 128; ++i2) {
                BlockPosition blockposition1 = blockposition;
                IBlockData iblockdata = Blocks.SEAGRASS.defaultBlockState();
                for (int j2 = 0; j2 < i2 / 16; ++j2) {
                    if (world.getBlockState(blockposition1 = blockposition1.offset(randomsource.nextInt(3) - 1, (randomsource.nextInt(3) - 1) * randomsource.nextInt(3) / 2, randomsource.nextInt(3) - 1)).isCollisionShapeFullBlock(world, blockposition1)) continue block0;
                }
                Holder<BiomeBase> holder = world.getBiome(blockposition1);
                if (holder.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL)) {
                    if (i2 == 0 && enumdirection != null && enumdirection.getAxis().isHorizontal()) {
                        iblockdata = BuiltInRegistries.BLOCK.getRandomElementOf(TagsBlock.WALL_CORALS, world.random).map(holder1 -> ((Block)holder1.value()).defaultBlockState()).orElse(iblockdata);
                        if (iblockdata.hasProperty(BlockCoralFanWallAbstract.FACING)) {
                            iblockdata = (IBlockData)iblockdata.setValue(BlockCoralFanWallAbstract.FACING, enumdirection);
                        }
                    } else if (randomsource.nextInt(4) == 0) {
                        iblockdata = BuiltInRegistries.BLOCK.getRandomElementOf(TagsBlock.UNDERWATER_BONEMEALS, world.random).map(holder1 -> ((Block)holder1.value()).defaultBlockState()).orElse(iblockdata);
                    }
                }
                if (iblockdata.is(TagsBlock.WALL_CORALS, blockbase_blockdata -> blockbase_blockdata.hasProperty(BlockCoralFanWallAbstract.FACING))) {
                    for (int k2 = 0; !iblockdata.canSurvive(world, blockposition1) && k2 < 4; ++k2) {
                        iblockdata = (IBlockData)iblockdata.setValue(BlockCoralFanWallAbstract.FACING, EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(randomsource));
                    }
                }
                if (!iblockdata.canSurvive(world, blockposition1)) continue;
                IBlockData iblockdata1 = world.getBlockState(blockposition1);
                if (iblockdata1.is(Blocks.WATER) && world.getFluidState(blockposition1).getAmount() == 8) {
                    world.setBlock(blockposition1, iblockdata, 3);
                    continue;
                }
                if (!iblockdata1.is(Blocks.SEAGRASS) || randomsource.nextInt(10) != 0) continue;
                ((IBlockFragilePlantElement)((Object)Blocks.SEAGRASS)).performBonemeal((WorldServer)world, randomsource, blockposition1, iblockdata1);
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
        IBlockData iblockdata = generatoraccess.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        if (block instanceof IBlockFragilePlantElement) {
            IBlockFragilePlantElement iblockfragileplantelement = (IBlockFragilePlantElement)((Object)block);
            BlockPosition blockposition1 = iblockfragileplantelement.getParticlePos(blockposition);
            switch (iblockfragileplantelement.getType()) {
                case NEIGHBOR_SPREADER: {
                    ParticleUtils.spawnParticles(generatoraccess, blockposition1, i2 * 3, 3.0, 1.0, false, Particles.HAPPY_VILLAGER);
                    break;
                }
                case GROWER: {
                    ParticleUtils.spawnParticleInBlock(generatoraccess, blockposition1, i2, Particles.HAPPY_VILLAGER);
                }
            }
        } else if (iblockdata.is(Blocks.WATER)) {
            ParticleUtils.spawnParticles(generatoraccess, blockposition, i2 * 3, 3.0, 1.0, false, Particles.HAPPY_VILLAGER);
        }
    }
}

