/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.DummyGeneratorAccess;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class ItemBucket
extends Item
implements DispensibleContainerItem {
    public final FluidType content;

    public ItemBucket(FluidType fluidtype, Item.Info item_info) {
        super(item_info);
        this.content = fluidtype;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemBucket.getPlayerPOVHitResult(world, entityhuman, this.content == FluidTypes.EMPTY ? RayTrace.FluidCollisionOption.SOURCE_ONLY : RayTrace.FluidCollisionOption.NONE);
        if (movingobjectpositionblock.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return InteractionResultWrapper.pass(itemstack);
        }
        if (movingobjectpositionblock.getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return InteractionResultWrapper.pass(itemstack);
        }
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        EnumDirection enumdirection = movingobjectpositionblock.getDirection();
        BlockPosition blockposition1 = blockposition.relative(enumdirection);
        if (world.mayInteract(entityhuman, blockposition) && entityhuman.mayUseItemAt(blockposition1, enumdirection, itemstack)) {
            BlockPosition blockposition2;
            if (this.content == FluidTypes.EMPTY) {
                IBlockData iblockdata = world.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (block instanceof IFluidSource) {
                    IFluidSource ifluidsource = (IFluidSource)((Object)block);
                    ItemStack dummyFluid = ifluidsource.pickupBlock(entityhuman, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (dummyFluid.isEmpty()) {
                        return InteractionResultWrapper.fail(itemstack);
                    }
                    PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)world, entityhuman, blockposition, blockposition, movingobjectpositionblock.getDirection(), itemstack, dummyFluid.getItem(), enumhand);
                    if (event.isCancelled()) {
                        ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutBlockChange(world, blockposition));
                        ((EntityPlayer)entityhuman).getBukkitEntity().updateInventory();
                        return InteractionResultWrapper.fail(itemstack);
                    }
                    ItemStack itemstack1 = ifluidsource.pickupBlock(entityhuman, world, blockposition, iblockdata);
                    if (!itemstack1.isEmpty()) {
                        entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
                        ifluidsource.getPickupSound().ifPresent(soundeffect -> entityhuman.playSound((SoundEffect)soundeffect, 1.0f, 1.0f));
                        world.gameEvent((Entity)entityhuman, GameEvent.FLUID_PICKUP, blockposition);
                        ItemStack itemstack2 = ItemLiquidUtil.createFilledResult(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
                        if (!world.isClientSide) {
                            CriterionTriggers.FILLED_BUCKET.trigger((EntityPlayer)entityhuman, itemstack1);
                        }
                        return InteractionResultWrapper.sidedSuccess(itemstack2, world.isClientSide());
                    }
                }
                return InteractionResultWrapper.fail(itemstack);
            }
            IBlockData iblockdata = world.getBlockState(blockposition);
            BlockPosition blockPosition = blockposition2 = iblockdata.getBlock() instanceof IFluidContainer && this.content == FluidTypes.WATER ? blockposition : blockposition1;
            if (this.emptyContents(entityhuman, world, blockposition2, movingobjectpositionblock, movingobjectpositionblock.getDirection(), blockposition, itemstack, enumhand)) {
                this.checkExtraContent(entityhuman, world, itemstack, blockposition2);
                if (entityhuman instanceof EntityPlayer) {
                    CriterionTriggers.PLACED_BLOCK.trigger((EntityPlayer)entityhuman, blockposition2, itemstack);
                }
                entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
                ItemStack itemstack1 = ItemLiquidUtil.createFilledResult(itemstack, entityhuman, ItemBucket.getEmptySuccessItem(itemstack, entityhuman));
                return InteractionResultWrapper.sidedSuccess(itemstack1, world.isClientSide());
            }
            return InteractionResultWrapper.fail(itemstack);
        }
        return InteractionResultWrapper.fail(itemstack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack itemstack, EntityHuman entityhuman) {
        return !entityhuman.hasInfiniteMaterials() ? new ItemStack(Items.BUCKET) : itemstack;
    }

    @Override
    public void checkExtraContent(@Nullable EntityHuman entityhuman, World world, ItemStack itemstack, BlockPosition blockposition) {
    }

    @Override
    public boolean emptyContents(@Nullable EntityHuman entityhuman, World world, BlockPosition blockposition, @Nullable MovingObjectPositionBlock movingobjectpositionblock) {
        return this.emptyContents(entityhuman, world, blockposition, movingobjectpositionblock, null, null, null, EnumHand.MAIN_HAND);
    }

    public boolean emptyContents(EntityHuman entityhuman, World world, BlockPosition blockposition, @Nullable MovingObjectPositionBlock movingobjectpositionblock, EnumDirection enumdirection, BlockPosition clicked, ItemStack itemstack, EnumHand enumhand) {
        PlayerBucketEmptyEvent event;
        IFluidContainer ifluidcontainer;
        FluidType fluidtype = this.content;
        if (!(fluidtype instanceof FluidTypeFlowing)) {
            return false;
        }
        FluidTypeFlowing fluidtypeflowing = (FluidTypeFlowing)fluidtype;
        IBlockData iblockdata = world.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        boolean flag = iblockdata.canBeReplaced(this.content);
        boolean flag1 = iblockdata.isAir() || flag || block instanceof IFluidContainer && (ifluidcontainer = (IFluidContainer)((Object)block)).canPlaceLiquid(entityhuman, world, blockposition, iblockdata, this.content);
        boolean flag2 = flag1;
        if (flag2 && entityhuman != null && (event = CraftEventFactory.callPlayerBucketEmptyEvent((WorldServer)world, entityhuman, blockposition, clicked, enumdirection, itemstack, enumhand)).isCancelled()) {
            ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutBlockChange(world, blockposition));
            ((EntityPlayer)entityhuman).getBukkitEntity().updateInventory();
            return false;
        }
        if (!flag2) {
            return movingobjectpositionblock != null && this.emptyContents(entityhuman, world, movingobjectpositionblock.getBlockPos().relative(movingobjectpositionblock.getDirection()), null, enumdirection, clicked, itemstack, enumhand);
        }
        if (world.dimensionType().ultraWarm() && this.content.is(TagsFluid.WATER)) {
            int i2 = blockposition.getX();
            int j2 = blockposition.getY();
            int k2 = blockposition.getZ();
            world.playSound(entityhuman, blockposition, SoundEffects.FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
            for (int l2 = 0; l2 < 8; ++l2) {
                world.addParticle(Particles.LARGE_SMOKE, (double)i2 + Math.random(), (double)j2 + Math.random(), (double)k2 + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof IFluidContainer) {
            ifluidcontainer = (IFluidContainer)((Object)block);
            if (this.content == FluidTypes.WATER) {
                ifluidcontainer.placeLiquid(world, blockposition, iblockdata, fluidtypeflowing.getSource(false));
                this.playEmptySound(entityhuman, world, blockposition);
                return true;
            }
        }
        if (!world.isClientSide && flag && !iblockdata.liquid()) {
            world.destroyBlock(blockposition, true);
        }
        if (!world.setBlock(blockposition, this.content.defaultFluidState().createLegacyBlock(), 11) && !iblockdata.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(entityhuman, world, blockposition);
        return true;
    }

    protected void playEmptySound(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        SoundEffect soundeffect = this.content.is(TagsFluid.LAVA) ? SoundEffects.BUCKET_EMPTY_LAVA : SoundEffects.BUCKET_EMPTY;
        generatoraccess.playSound(entityhuman, blockposition, soundeffect, SoundCategory.BLOCKS, 1.0f, 1.0f);
        generatoraccess.gameEvent((Entity)entityhuman, GameEvent.FLUID_PLACE, blockposition);
    }
}

