/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class ItemCarrotStick<T extends Entity>
extends Item {
    private final EntityTypes<T> canInteractWith;
    private final int consumeItemDamage;

    public ItemCarrotStick(Item.Info var0, EntityTypes<T> var1, int var2) {
        super(var0);
        this.canInteractWith = var1;
        this.consumeItemDamage = var2;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (var0.isClientSide) {
            return InteractionResultWrapper.pass(var3);
        }
        Entity var4 = var1.getControlledVehicle();
        if (var1.isPassenger() && var4 instanceof ISteerable) {
            ISteerable var5 = (ISteerable)((Object)var4);
            if (var4.getType() == this.canInteractWith && var5.boost()) {
                EnumItemSlot var6 = EntityLiving.getSlotForHand(var2);
                ItemStack var7 = var3.hurtAndConvertOnBreak(this.consumeItemDamage, Items.FISHING_ROD, var1, var6);
                return InteractionResultWrapper.success(var7);
            }
        }
        var1.awardStat(StatisticList.ITEM_USED.get(this));
        return InteractionResultWrapper.pass(var3);
    }
}

