/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ItemChorusFruit
extends Item {
    public ItemChorusFruit(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack itemstack, World world, EntityLiving entityliving) {
        ItemStack itemstack1 = super.finishUsingItem(itemstack, world, entityliving);
        if (!world.isClientSide) {
            for (int i2 = 0; i2 < 16; ++i2) {
                SoundCategory soundcategory;
                SoundEffect soundeffect;
                double d0 = entityliving.getX() + (entityliving.getRandom().nextDouble() - 0.5) * 16.0;
                double d1 = MathHelper.clamp(entityliving.getY() + (double)(entityliving.getRandom().nextInt(16) - 8), (double)world.getMinBuildHeight(), (double)(world.getMinBuildHeight() + ((WorldServer)world).getLogicalHeight() - 1));
                double d2 = entityliving.getZ() + (entityliving.getRandom().nextDouble() - 0.5) * 16.0;
                if (entityliving.isPassenger()) {
                    entityliving.stopRiding();
                }
                Vec3D vec3d = entityliving.position();
                Optional<Boolean> status = entityliving.randomTeleport(d0, d1, d2, true, PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT);
                if (!status.isPresent()) break;
                if (!status.get().booleanValue()) continue;
                world.gameEvent(GameEvent.TELEPORT, vec3d, GameEvent.a.of(entityliving));
                if (entityliving instanceof EntityFox) {
                    soundeffect = SoundEffects.FOX_TELEPORT;
                    soundcategory = SoundCategory.NEUTRAL;
                } else {
                    soundeffect = SoundEffects.CHORUS_FRUIT_TELEPORT;
                    soundcategory = SoundCategory.PLAYERS;
                }
                world.playSound((EntityHuman)null, entityliving.getX(), entityliving.getY(), entityliving.getZ(), soundeffect, soundcategory);
                entityliving.resetFallDistance();
                break;
            }
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entityliving;
                entityhuman.resetCurrentImpulseContext();
                entityhuman.getCooldowns().addCooldown(this, 20);
            }
        }
        return itemstack1;
    }
}

