/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepDyeWoolEvent;

public class ItemDye
extends Item
implements SignApplicator {
    private static final Map<EnumColor, ItemDye> ITEM_BY_COLOR = Maps.newEnumMap(EnumColor.class);
    private final EnumColor dyeColor;

    public ItemDye(EnumColor enumcolor, Item.Info item_info) {
        super(item_info);
        this.dyeColor = enumcolor;
        ITEM_BY_COLOR.put(enumcolor, this);
    }

    @Override
    public EnumInteractionResult interactLivingEntity(ItemStack itemstack, EntityHuman entityhuman, EntityLiving entityliving, EnumHand enumhand) {
        EntitySheep entitysheep;
        if (entityliving instanceof EntitySheep && (entitysheep = (EntitySheep)entityliving).isAlive() && !entitysheep.isSheared() && entitysheep.getColor() != this.dyeColor) {
            entitysheep.level().playSound(entityhuman, entitysheep, SoundEffects.DYE_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (!entityhuman.level().isClientSide) {
                byte bColor = (byte)this.dyeColor.getId();
                SheepDyeWoolEvent event = new SheepDyeWoolEvent((Sheep)entitysheep.getBukkitEntity(), DyeColor.getByWoolData((byte)bColor), (Player)entityhuman.getBukkitEntity());
                entitysheep.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return EnumInteractionResult.PASS;
                }
                entitysheep.setColor(EnumColor.byId(event.getColor().getWoolData()));
                itemstack.shrink(1);
            }
            return EnumInteractionResult.sidedSuccess(entityhuman.level().isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public EnumColor getDyeColor() {
        return this.dyeColor;
    }

    public static ItemDye byColor(EnumColor enumcolor) {
        return ITEM_BY_COLOR.get(enumcolor);
    }

    @Override
    public boolean tryApplyToSign(World world, TileEntitySign tileentitysign, boolean flag, EntityHuman entityhuman) {
        if (tileentitysign.updateText(signtext -> signtext.setColor(this.getDyeColor()), flag)) {
            world.playSound((EntityHuman)null, tileentitysign.getBlockPos(), SoundEffects.DYE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

