/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class ItemEndCrystal
extends Item {
    public ItemEndCrystal(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        double d2;
        double d1;
        BlockPosition blockposition;
        World world = itemactioncontext.getLevel();
        IBlockData iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (!iblockdata.is(Blocks.OBSIDIAN) && !iblockdata.is(Blocks.BEDROCK)) {
            return EnumInteractionResult.FAIL;
        }
        BlockPosition blockposition1 = blockposition.above();
        if (!world.isEmptyBlock(blockposition1)) {
            return EnumInteractionResult.FAIL;
        }
        double d0 = blockposition1.getX();
        List<Entity> list = world.getEntities(null, new AxisAlignedBB(d0, d1 = (double)blockposition1.getY(), d2 = (double)blockposition1.getZ(), d0 + 1.0, d1 + 2.0, d2 + 1.0));
        if (!list.isEmpty()) {
            return EnumInteractionResult.FAIL;
        }
        if (world instanceof WorldServer) {
            EntityEnderCrystal entityendercrystal = new EntityEnderCrystal(world, d0 + 0.5, d1, d2 + 0.5);
            entityendercrystal.setShowBottom(false);
            if (CraftEventFactory.callEntityPlaceEvent(itemactioncontext, entityendercrystal).isCancelled()) {
                return EnumInteractionResult.FAIL;
            }
            world.addFreshEntity(entityendercrystal);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.ENTITY_PLACE, blockposition1);
            EnderDragonBattle enderdragonbattle = ((WorldServer)world).getDragonFight();
            if (enderdragonbattle != null) {
                enderdragonbattle.tryRespawn();
            }
        }
        itemactioncontext.getItemInHand().shrink(1);
        return EnumInteractionResult.sidedSuccess(world.isClientSide);
    }
}

