/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class ItemEnderEye
extends Item {
    public ItemEnderEye(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        BlockPosition blockposition;
        World world = itemactioncontext.getLevel();
        IBlockData iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (iblockdata.is(Blocks.END_PORTAL_FRAME) && !iblockdata.getValue(BlockEnderPortalFrame.HAS_EYE).booleanValue()) {
            if (world.isClientSide) {
                return EnumInteractionResult.SUCCESS;
            }
            IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(BlockEnderPortalFrame.HAS_EYE, true);
            Block.pushEntitiesUp(iblockdata, iblockdata1, world, blockposition);
            world.setBlock(blockposition, iblockdata1, 2);
            world.updateNeighbourForOutputSignal(blockposition, Blocks.END_PORTAL_FRAME);
            itemactioncontext.getItemInHand().shrink(1);
            world.levelEvent(1503, blockposition, 0);
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = BlockEnderPortalFrame.getOrCreatePortalShape().find(world, blockposition);
            if (shapedetector_shapedetectorcollection != null) {
                BlockPosition blockposition1 = shapedetector_shapedetectorcollection.getFrontTopLeft().offset(-3, 0, -3);
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j2 = 0; j2 < 3; ++j2) {
                        world.setBlock(blockposition1.offset(i2, 0, j2), Blocks.END_PORTAL.defaultBlockState(), 2);
                    }
                }
                int viewDistance = world.getCraftServer().getViewDistance() * 16;
                BlockPosition soundPos = blockposition1.offset(1, 0, 1);
                for (EntityPlayer player : world.getServer().getPlayerList().players) {
                    double deltaX = (double)soundPos.getX() - player.getX();
                    double deltaZ = (double)soundPos.getZ() - player.getZ();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (world.spigotConfig.endPortalSoundRadius > 0 && distanceSquared > (double)(world.spigotConfig.endPortalSoundRadius * world.spigotConfig.endPortalSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                        player.connection.send(new PacketPlayOutWorldEvent(1038, new BlockPosition((int)relativeX, soundPos.getY(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.connection.send(new PacketPlayOutWorldEvent(1038, soundPos, 0, true));
                }
            }
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack itemstack, EntityLiving entityliving) {
        return 0;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        WorldServer worldserver;
        BlockPosition blockposition;
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemEnderEye.getPlayerPOVHitResult(world, entityhuman, RayTrace.FluidCollisionOption.NONE);
        if (movingobjectpositionblock.getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK && world.getBlockState(movingobjectpositionblock.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResultWrapper.pass(itemstack);
        }
        entityhuman.startUsingItem(enumhand);
        if (world instanceof WorldServer && (blockposition = (worldserver = (WorldServer)world).findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, entityhuman.blockPosition(), 100, false)) != null) {
            EntityEnderSignal entityendersignal = new EntityEnderSignal(world, entityhuman.getX(), entityhuman.getY(0.5), entityhuman.getZ());
            entityendersignal.setItem(itemstack);
            entityendersignal.signalTo(blockposition);
            world.gameEvent(GameEvent.PROJECTILE_SHOOT, entityendersignal.position(), GameEvent.a.of(entityhuman));
            if (!world.addFreshEntity(entityendersignal)) {
                return new InteractionResultWrapper<ItemStack>(EnumInteractionResult.FAIL, itemstack);
            }
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                CriterionTriggers.USED_ENDER_EYE.trigger(entityplayer, blockposition);
            }
            float f2 = MathHelper.lerp(world.random.nextFloat(), 0.33f, 0.5f);
            world.playSound((EntityHuman)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEffects.ENDER_EYE_LAUNCH, SoundCategory.NEUTRAL, 1.0f, f2);
            itemstack.consume(1, entityhuman);
            entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
            entityhuman.swing(enumhand, true);
            return InteractionResultWrapper.success(itemstack);
        }
        return InteractionResultWrapper.consume(itemstack);
    }
}

