/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        BlockPosition blockposition;
        World world = itemactioncontext.getLevel();
        IBlockData iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (iblockdata.is(TagsBlock.FENCES)) {
            EntityHuman entityhuman = itemactioncontext.getPlayer();
            if (!world.isClientSide && entityhuman != null) {
                ItemLeash.bindPlayerMobs(entityhuman, world, blockposition, itemactioncontext.getHand());
            }
            return EnumInteractionResult.sidedSuccess(world.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman entityhuman, World world, BlockPosition blockposition, EnumHand enumhand) {
        Entity entityleash = null;
        List<Leashable> list = ItemLeash.leashableInArea(world, blockposition, leashable -> leashable.getLeashHolder() == entityhuman);
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity leashed;
            Leashable leashable2 = iterator.next();
            if (entityleash == null) {
                entityleash = EntityLeash.getOrCreateKnot(world, blockposition);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityleash.getBukkitEntity(), entityhuman != null ? (Player)entityhuman.getBukkitEntity() : null, (Block)CraftBlock.at(world, blockposition), BlockFace.SELF, hand);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entityleash.discard(null);
                    return EnumInteractionResult.PASS;
                }
                ((EntityLeash)entityleash).playPlacementSound();
            }
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), entityleash, entityhuman, enumhand).isCancelled()) {
                iterator.remove();
                continue;
            }
            leashable2.setLeashedTo(entityleash, true);
        }
        if (!list.isEmpty()) {
            world.gameEvent(GameEvent.BLOCK_ATTACH, blockposition, GameEvent.a.of(entityhuman));
            return EnumInteractionResult.SUCCESS;
        }
        if (entityleash != null) {
            entityleash.discard(null);
        }
        return EnumInteractionResult.PASS;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman entityhuman, World world, BlockPosition blockposition) {
        return ItemLeash.bindPlayerMobs(entityhuman, world, blockposition, EnumHand.MAIN_HAND);
    }

    public static List<Leashable> leashableInArea(World world, BlockPosition blockposition, Predicate<Leashable> predicate) {
        double d0 = 7.0;
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)i2 - 7.0, (double)j2 - 7.0, (double)k2 - 7.0, (double)i2 + 7.0, (double)j2 + 7.0, (double)k2 + 7.0);
        Stream stream = world.getEntitiesOfClass(Entity.class, axisalignedbb, entity -> {
            Leashable leashable;
            if (entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity))) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }).stream();
        Objects.requireNonNull(Leashable.class);
        return stream.map(Leashable.class::cast).toList();
    }
}

