/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.util.Vector;

public class ItemMinecart
extends Item {
    private static final IDispenseBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseBehaviorItem(){
        private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

        @Override
        public ItemStack execute(SourceBlock sourceblock, ItemStack itemstack) {
            double d3;
            BlockPropertyTrackPosition blockpropertytrackposition;
            EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
            WorldServer worldserver = sourceblock.level();
            Vec3D vec3d = sourceblock.center();
            double d0 = vec3d.x() + (double)enumdirection.getStepX() * 1.125;
            double d1 = Math.floor(vec3d.y()) + (double)enumdirection.getStepY();
            double d2 = vec3d.z() + (double)enumdirection.getStepZ() * 1.125;
            BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
            IBlockData iblockdata = worldserver.getBlockState(blockposition);
            BlockPropertyTrackPosition blockPropertyTrackPosition = blockpropertytrackposition = iblockdata.getBlock() instanceof BlockMinecartTrackAbstract ? iblockdata.getValue(((BlockMinecartTrackAbstract)iblockdata.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            if (iblockdata.is(TagsBlock.RAILS)) {
                d3 = blockpropertytrackposition.isAscending() ? 0.6 : 0.1;
            } else {
                if (!iblockdata.isAir() || !worldserver.getBlockState(blockposition.below()).is(TagsBlock.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
                }
                IBlockData iblockdata1 = worldserver.getBlockState(blockposition.below());
                BlockPropertyTrackPosition blockpropertytrackposition1 = iblockdata1.getBlock() instanceof BlockMinecartTrackAbstract ? iblockdata1.getValue(((BlockMinecartTrackAbstract)iblockdata1.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
                d3 = enumdirection != EnumDirection.DOWN && blockpropertytrackposition1.isAscending() ? -0.4 : -0.9;
            }
            ItemStack itemstack1 = itemstack.split(1);
            CraftBlock block2 = CraftBlock.at(worldserver, sourceblock.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
            BlockDispenseEvent event = new BlockDispenseEvent((Block)block2, (org.bukkit.inventory.ItemStack)craftItem.clone(), new Vector(d0, d1 + d3, d2));
            if (!BlockDispenser.eventFired) {
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                itemstack.grow(1);
                return itemstack;
            }
            if (!event.getItem().equals((Object)craftItem)) {
                itemstack.grow(1);
                ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                if (idispensebehavior != IDispenseBehavior.NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
            }
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            EntityMinecartAbstract entityminecartabstract = EntityMinecartAbstract.createMinecart(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), ((ItemMinecart)itemstack1.getItem()).type, itemstack1, null);
            if (!worldserver.addFreshEntity(entityminecartabstract)) {
                itemstack.grow(1);
            }
            return itemstack;
        }

        @Override
        protected void playSound(SourceBlock sourceblock) {
            sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
        }
    };
    final EntityMinecartAbstract.EnumMinecartType type;

    public ItemMinecart(EntityMinecartAbstract.EnumMinecartType entityminecartabstract_enumminecarttype, Item.Info item_info) {
        super(item_info);
        this.type = entityminecartabstract_enumminecarttype;
        BlockDispenser.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        BlockPosition blockposition;
        World world = itemactioncontext.getLevel();
        IBlockData iblockdata = world.getBlockState(blockposition = itemactioncontext.getClickedPos());
        if (!iblockdata.is(TagsBlock.RAILS)) {
            return EnumInteractionResult.FAIL;
        }
        ItemStack itemstack = itemactioncontext.getItemInHand();
        if (world instanceof WorldServer) {
            EntityMinecartAbstract entityminecartabstract;
            WorldServer worldserver = (WorldServer)world;
            BlockPropertyTrackPosition blockpropertytrackposition = iblockdata.getBlock() instanceof BlockMinecartTrackAbstract ? iblockdata.getValue(((BlockMinecartTrackAbstract)iblockdata.getBlock()).getShapeProperty()) : BlockPropertyTrackPosition.NORTH_SOUTH;
            double d0 = 0.0;
            if (blockpropertytrackposition.isAscending()) {
                d0 = 0.5;
            }
            if (CraftEventFactory.callEntityPlaceEvent(itemactioncontext, entityminecartabstract = EntityMinecartAbstract.createMinecart(worldserver, (double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.0625 + d0, (double)blockposition.getZ() + 0.5, this.type, itemstack, itemactioncontext.getPlayer())).isCancelled()) {
                return EnumInteractionResult.FAIL;
            }
            if (!worldserver.addFreshEntity(entityminecartabstract)) {
                return EnumInteractionResult.PASS;
            }
            worldserver.gameEvent(GameEvent.ENTITY_PLACE, blockposition, GameEvent.a.of(itemactioncontext.getPlayer(), worldserver.getBlockState(blockposition.below())));
        }
        itemstack.shrink(1);
        return EnumInteractionResult.sidedSuccess(world.isClientSide);
    }
}

