/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> BY_ID = Maps.newIdentityHashMap();
    private static final MapCodec<EntityTypes<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    private final int backgroundColor;
    private final int highlightColor;
    private final EntityTypes<?> defaultType;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> entitytypes, int i2, int j2, Item.Info item_info) {
        super(item_info);
        this.defaultType = entitytypes;
        this.backgroundColor = i2;
        this.highlightColor = j2;
        BY_ID.put(entitytypes, this);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        World world = itemactioncontext.getLevel();
        if (!(world instanceof WorldServer)) {
            return EnumInteractionResult.SUCCESS;
        }
        ItemStack itemstack = itemactioncontext.getItemInHand();
        BlockPosition blockposition = itemactioncontext.getClickedPos();
        EnumDirection enumdirection = itemactioncontext.getClickedFace();
        IBlockData iblockdata = world.getBlockState(blockposition);
        TileEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityTypes<?> entitytypes = this.getType(itemstack);
            spawner.setEntityId(entitytypes, world.getRandom());
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.BLOCK_CHANGE, blockposition);
            itemstack.shrink(1);
            return EnumInteractionResult.CONSUME;
        }
        BlockPosition blockposition1 = iblockdata.getCollisionShape(world, blockposition).isEmpty() ? blockposition : blockposition.relative(enumdirection);
        EntityTypes<?> entitytypes = this.getType(itemstack);
        if (entitytypes.spawn((WorldServer)world, itemstack, itemactioncontext.getPlayer(), blockposition1, EnumMobSpawn.SPAWN_EGG, true, !Objects.equals(blockposition, blockposition1) && enumdirection == EnumDirection.UP) != null) {
            itemstack.shrink(1);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.ENTITY_PLACE, blockposition);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemMonsterEgg.getPlayerPOVHitResult(world, entityhuman, RayTrace.FluidCollisionOption.SOURCE_ONLY);
        if (movingobjectpositionblock.getType() != MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            return InteractionResultWrapper.pass(itemstack);
        }
        if (!(world instanceof WorldServer)) {
            return InteractionResultWrapper.success(itemstack);
        }
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        if (!(world.getBlockState(blockposition).getBlock() instanceof BlockFluids)) {
            return InteractionResultWrapper.pass(itemstack);
        }
        if (world.mayInteract(entityhuman, blockposition) && entityhuman.mayUseItemAt(blockposition, movingobjectpositionblock.getDirection(), itemstack)) {
            EntityTypes<?> entitytypes = this.getType(itemstack);
            Object entity = entitytypes.spawn((WorldServer)world, itemstack, entityhuman, blockposition, EnumMobSpawn.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultWrapper.pass(itemstack);
            }
            itemstack.consume(1, entityhuman);
            entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
            world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, ((Entity)entity).position());
            return InteractionResultWrapper.consume(itemstack);
        }
        return InteractionResultWrapper.fail(itemstack);
    }

    public boolean spawnsEntity(ItemStack itemstack, EntityTypes<?> entitytypes) {
        return Objects.equals(this.getType(itemstack), entitytypes);
    }

    public int getColor(int i2) {
        return i2 == 0 ? this.backgroundColor : this.highlightColor;
    }

    @Nullable
    public static ItemMonsterEgg byId(@Nullable EntityTypes<?> entitytypes) {
        return BY_ID.get(entitytypes);
    }

    public static Iterable<ItemMonsterEgg> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityTypes<?> getType(ItemStack itemstack) {
        CustomData customdata = itemstack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        return !customdata.isEmpty() ? customdata.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.defaultType) : this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<EntityInsentient> spawnOffspringFromSpawnEgg(EntityHuman entityhuman, EntityInsentient entityinsentient, EntityTypes<? extends EntityInsentient> entitytypes, WorldServer worldserver, Vec3D vec3d, ItemStack itemstack) {
        if (!this.spawnsEntity(itemstack, entitytypes)) {
            return Optional.empty();
        }
        EntityInsentient object = entityinsentient instanceof EntityAgeable ? ((EntityAgeable)entityinsentient).getBreedOffspring(worldserver, (EntityAgeable)entityinsentient) : entitytypes.create(worldserver);
        if (object == null) {
            return Optional.empty();
        }
        object.setBaby(true);
        if (!object.isBaby()) {
            return Optional.empty();
        }
        object.moveTo(vec3d.x(), vec3d.y(), vec3d.z(), 0.0f, 0.0f);
        worldserver.addFreshEntityWithPassengers(object, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        object.setCustomName(itemstack.get(DataComponents.CUSTOM_NAME));
        itemstack.consume(1, entityhuman);
        return Optional.of(object);
    }
}

