/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class ItemProjectileWeapon
extends Item {
    public static final Predicate<ItemStack> ARROW_ONLY = itemstack -> itemstack.is(TagsItem.ARROWS);
    public static final Predicate<ItemStack> ARROW_OR_FIREWORK = ARROW_ONLY.or(itemstack -> itemstack.is(Items.FIREWORK_ROCKET));

    public ItemProjectileWeapon(Item.Info item_info) {
        super(item_info);
    }

    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return this.getAllSupportedProjectiles();
    }

    public abstract Predicate<ItemStack> getAllSupportedProjectiles();

    public static ItemStack getHeldProjectile(EntityLiving entityliving, Predicate<ItemStack> predicate) {
        return predicate.test(entityliving.getItemInHand(EnumHand.OFF_HAND)) ? entityliving.getItemInHand(EnumHand.OFF_HAND) : (predicate.test(entityliving.getItemInHand(EnumHand.MAIN_HAND)) ? entityliving.getItemInHand(EnumHand.MAIN_HAND) : ItemStack.EMPTY);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    public abstract int getDefaultProjectileRange();

    protected void shoot(WorldServer worldserver, EntityLiving entityliving, EnumHand enumhand, ItemStack itemstack, List<ItemStack> list, float f2, float f1, boolean flag, @Nullable EntityLiving entityliving1) {
        float f22 = EnchantmentManager.processProjectileSpread(worldserver, itemstack, entityliving, 0.0f);
        float f3 = list.size() == 1 ? 0.0f : 2.0f * f22 / (float)(list.size() - 1);
        float f4 = (float)((list.size() - 1) % 2) * f3 / 2.0f;
        float f5 = 1.0f;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ItemStack itemstack1 = list.get(i2);
            if (itemstack1.isEmpty()) continue;
            float f6 = f4 + f5 * (float)((i2 + 1) / 2) * f3;
            f5 = -f5;
            IProjectile iprojectile = this.createProjectile(worldserver, entityliving, itemstack, itemstack1, flag);
            this.shootProjectile(entityliving, iprojectile, i2, f2, f1, f6, entityliving1);
            EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(entityliving, itemstack, itemstack1, iprojectile, enumhand, f2, true);
            if (event.isCancelled()) {
                event.getProjectile().remove();
                return;
            }
            if (event.getProjectile() == iprojectile.getBukkitEntity() && !worldserver.addFreshEntity(iprojectile)) {
                if (entityliving instanceof EntityPlayer) {
                    ((EntityPlayer)entityliving).getBukkitEntity().updateInventory();
                }
                return;
            }
            itemstack.hurtAndBreak(this.getDurabilityUse(itemstack1), entityliving, EntityLiving.getSlotForHand(enumhand));
            if (itemstack.isEmpty()) break;
        }
    }

    protected int getDurabilityUse(ItemStack itemstack) {
        return 1;
    }

    protected abstract void shootProjectile(EntityLiving var1, IProjectile var2, int var3, float var4, float var5, float var6, @Nullable EntityLiving var7);

    protected IProjectile createProjectile(World world, EntityLiving entityliving, ItemStack itemstack, ItemStack itemstack1, boolean flag) {
        ItemArrow itemarrow1;
        Item item = itemstack1.getItem();
        ItemArrow itemarrow = item instanceof ItemArrow ? (itemarrow1 = (ItemArrow)item) : (ItemArrow)Items.ARROW;
        ItemArrow itemarrow2 = itemarrow;
        EntityArrow entityarrow = itemarrow2.createArrow(world, itemstack1, entityliving, itemstack);
        if (flag) {
            entityarrow.setCritArrow(true);
        }
        return entityarrow;
    }

    protected static List<ItemStack> draw(ItemStack itemstack, ItemStack itemstack1, EntityLiving entityliving) {
        int i2;
        if (itemstack1.isEmpty()) {
            return List.of();
        }
        World world = entityliving.level();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            i2 = EnchantmentManager.processProjectileCount(worldserver, itemstack, entityliving, 1);
        } else {
            i2 = 1;
        }
        int j2 = i2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(j2);
        ItemStack itemstack2 = itemstack1.copy();
        for (int k2 = 0; k2 < j2; ++k2) {
            ItemStack itemstack3 = ItemProjectileWeapon.useAmmo(itemstack, k2 == 0 ? itemstack1 : itemstack2, entityliving, k2 > 0);
            if (itemstack3.isEmpty()) continue;
            list.add(itemstack3);
        }
        return list;
    }

    protected static ItemStack useAmmo(ItemStack itemstack, ItemStack itemstack1, EntityLiving entityliving, boolean flag) {
        ItemStack itemstack2;
        int i2;
        World world;
        if (!flag && !entityliving.hasInfiniteMaterials() && (world = entityliving.level()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            i2 = EnchantmentManager.processAmmoUse(worldserver, itemstack, itemstack1, 1);
        } else {
            i2 = 0;
        }
        int j2 = i2;
        if (j2 > itemstack1.getCount()) {
            return ItemStack.EMPTY;
        }
        if (j2 == 0) {
            itemstack2 = itemstack1.copyWithCount(1);
            itemstack2.set(DataComponents.INTANGIBLE_PROJECTILE, Unit.INSTANCE);
            return itemstack2;
        }
        itemstack2 = itemstack1.split(j2);
        if (itemstack1.isEmpty() && entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            entityhuman.getInventory().removeItem(itemstack1);
        }
        return itemstack2;
    }
}

