/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.NullOps;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.saveddata.maps.MapId;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    public static final Codec<Holder<Item>> ITEM_NON_AIR_CODEC = BuiltInRegistries.ITEM.holderByNameCodec().validate(holder -> holder.is(Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)holder));
    public static final Codec<ItemStack> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
    public static final Codec<ItemStack> STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
    public static final Codec<ItemStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC = ITEM_NON_AIR_CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){
        private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            int i2 = registryfriendlybytebuf.readVarInt();
            if (i2 <= 0) {
                return EMPTY;
            }
            Holder holder = (Holder)ITEM_STREAM_CODEC.decode(registryfriendlybytebuf);
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode(registryfriendlybytebuf);
            ItemStack itemstack = new ItemStack(holder, i2, datacomponentpatch);
            if (!datacomponentpatch.isEmpty()) {
                CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
            }
            return itemstack;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.isEmpty() || itemstack.getItem() == null) {
                registryfriendlybytebuf.writeVarInt(0);
            } else {
                registryfriendlybytebuf.writeVarInt(itemstack.getCount());
                itemstack = itemstack.copy();
                CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                ITEM_STREAM_CODEC.encode(registryfriendlybytebuf, itemstack.getItemHolder());
                DataComponentPatch.STREAM_CODEC.encode(registryfriendlybytebuf, itemstack.components.asPatch());
            }
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            ItemStack itemstack = (ItemStack)OPTIONAL_STREAM_CODEC.decode(registryfriendlybytebuf);
            if (itemstack.isEmpty()) {
                throw new DecoderException("Empty ItemStack not allowed");
            }
            return itemstack;
        }

        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
            if (itemstack.isEmpty()) {
                throw new EncoderException("Empty ItemStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode(registryfriendlybytebuf, itemstack);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ItemStack EMPTY = new ItemStack((Void)null);
    private static final IChatBaseComponent DISABLED_ITEM_TOOLTIP = IChatBaseComponent.translatable("item.disabled").withStyle(EnumChatFormat.RED);
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    private static DataResult<ItemStack> validateStrict(ItemStack itemstack) {
        DataResult<Unit> dataresult = ItemStack.validateComponents(itemstack.getComponents());
        return dataresult.isError() ? dataresult.map(unit -> itemstack) : (itemstack.getCount() > itemstack.getMaxStackSize() ? DataResult.error(() -> {
            int i2 = itemstack.getCount();
            return "Item stack with stack size of " + i2 + " was larger than maximum: " + itemstack.getMaxStackSize();
        }) : DataResult.success((Object)itemstack));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)streamcodec.decode(registryfriendlybytebuf);
                if (!itemstack.isEmpty()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                streamcodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public ItemStack(IMaterial imaterial) {
        this(imaterial, 1);
    }

    public ItemStack(Holder<Item> holder) {
        this(holder.value(), 1);
    }

    public ItemStack(Holder<Item> holder, int i2, DataComponentPatch datacomponentpatch) {
        this(holder.value(), i2, PatchedDataComponentMap.fromPatch(holder.value().components(), datacomponentpatch));
    }

    public ItemStack(Holder<Item> holder, int i2) {
        this(holder.value(), i2);
    }

    public ItemStack(IMaterial imaterial, int i2) {
        this(imaterial, i2, new PatchedDataComponentMap(imaterial.asItem().components()));
    }

    private ItemStack(IMaterial imaterial, int i2, PatchedDataComponentMap patcheddatacomponentmap) {
        this.item = imaterial.asItem();
        this.count = i2;
        this.components = patcheddatacomponentmap;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void ovoid) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap datacomponentmap) {
        int j2;
        ItemStack itemstack;
        int i2;
        if (datacomponentmap.has(DataComponents.MAX_DAMAGE) && datacomponentmap.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = datacomponentmap.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        Iterator<ItemStack> iterator = itemcontainercontents.nonEmptyItems().iterator();
        do {
            if (iterator.hasNext()) continue;
            return DataResult.success((Object)((Object)Unit.INSTANCE));
        } while ((i2 = (itemstack = iterator.next()).getCount()) <= (j2 = itemstack.getMaxStackSize()));
        int finalI = i2;
        int finalJ = j2;
        return DataResult.error(() -> "Item stack with count of " + finalI + " was larger than maximum: " + finalJ);
    }

    public static Optional<ItemStack> parse(HolderLookup.a holderlookup_a, NBTBase nbtbase) {
        return CODEC.parse(holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)nbtbase).resultOrPartial(s2 -> LOGGER.error("Tried to load invalid item: '{}'", s2));
    }

    public static ItemStack parseOptional(HolderLookup.a holderlookup_a, NBTTagCompound nbttagcompound) {
        return nbttagcompound.isEmpty() ? EMPTY : ItemStack.parse(holderlookup_a, nbttagcompound).orElse(EMPTY);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet featureflagset) {
        return this.isEmpty() || this.getItem().isEnabled(featureflagset);
    }

    public ItemStack split(int i2) {
        int j2 = Math.min(i2, this.getCount());
        ItemStack itemstack = this.copyWithCount(j2);
        this.shrink(j2);
        return itemstack;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        this.setCount(0);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> tagkey) {
        return this.getItem().builtInRegistryHolder().is(tagkey);
    }

    public boolean is(Item item) {
        return this.getItem() == item;
    }

    public boolean is(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> holder) {
        return this.getItem().builtInRegistryHolder() == holder;
    }

    public boolean is(HolderSet<Item> holderset) {
        return holderset.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext) {
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = itemactioncontext.getPlayer();
        BlockPosition blockposition = itemactioncontext.getClickedPos();
        if (entityhuman != null && !entityhuman.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new ShapeDetectorBlock(itemactioncontext.getLevel(), blockposition, false))) {
            return EnumInteractionResult.PASS;
        }
        Item item = this.getItem();
        DataComponentPatch oldData = this.components.asPatch();
        int oldCount = this.getCount();
        WorldServer world = (WorldServer)itemactioncontext.getLevel();
        if (!(item instanceof ItemBucket) && !(item instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (item == Items.BONE_MEAL) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.useOn(itemactioncontext);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.components.asPatch();
        int newCount = this.getCount();
        this.setCount(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.consumesAction() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean bl = this.getItem() == Items.BONE_MEAL;
                structureEvent = new StructureGrowEvent(location, treeType, bl, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent blockFertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            blockFertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)blockFertilizeEvent);
            if (!blockFertilizeEvent.isCancelled()) {
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                }
                entityhuman.awardStat(StatisticList.ITEM_USED.get(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.indicateItemUse()) {
            EnumHand enumhand = itemactioncontext.getHand();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.getX(), blockposition.getY(), blockposition.getZ());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.getX(), blockposition.getY(), blockposition.getZ());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.FAIL;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (EnumDirection dir : EnumDirection.values()) {
                    ((EntityPlayer)entityhuman).connection.send(new PacketPlayOutBlockChange(world, placedPos.relative(dir)));
                }
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData iBlockData;
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (Map.Entry entry : world.capturedTileEntities.entrySet()) {
                    world.setBlockEntity((TileEntity)entry.getValue());
                }
                for (BlockState blockState : blocks) {
                    int updateFlag = ((CraftBlockState)blockState).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockState).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockState).getPosition();
                    IBlockData block = world.getBlockState(newblockposition);
                    if (!(block.getBlock() instanceof BlockTileEntity)) {
                        block.onPlace(world, newblockposition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.getBlockState(newblockposition), updateFlag, 512);
                }
                if (this.item == Items.WITHER_SKELETON_SKULL) {
                    TileEntity tileEntity;
                    BlockPosition bp = blockposition;
                    if (!world.getBlockState(blockposition).canBeReplaced()) {
                        bp = !world.getBlockState(blockposition).isSolid() ? null : bp.relative(itemactioncontext.getClickedFace());
                    }
                    if (bp != null && (tileEntity = world.getBlockEntity(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.checkSpawn(world, bp, (TileEntitySkull)tileEntity);
                    }
                }
                if (this.item instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        TileEntity tileEntity = world.getBlockEntity(ItemSign.openSign);
                        if (tileEntity instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)tileEntity;
                            Block block = world.getBlockState(ItemSign.openSign).getBlock();
                            if (block instanceof BlockSign) {
                                BlockSign blockSign = (BlockSign)block;
                                blockSign.openTextEdit(entityhuman, tileentitysign, true, PlayerSignOpenEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.item instanceof ItemBed && (iBlockData = world.getBlockState(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).getBlock() instanceof BlockBed) {
                    world.blockUpdated(position, Blocks.AIR);
                    iBlockData.updateNeighbourShapes(world, position, 3);
                }
                if (this.item instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.item).getBlock().defaultBlockState().getSoundType();
                    world.playSound(entityhuman, blockposition, soundeffecttype.getPlaceSound(), SoundCategory.BLOCKS, (soundeffecttype.getVolume() + 1.0f) / 2.0f, soundeffecttype.getPitch() * 0.8f);
                }
                entityhuman.awardStat(StatisticList.ITEM_USED.get(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float getDestroySpeed(IBlockData iblockdata) {
        return this.getItem().getDestroySpeed(this, iblockdata);
    }

    public InteractionResultWrapper<ItemStack> use(net.minecraft.world.level.World world, EntityHuman entityhuman, EnumHand enumhand) {
        return this.getItem().use(world, entityhuman, enumhand);
    }

    public ItemStack finishUsingItem(net.minecraft.world.level.World world, EntityLiving entityliving) {
        return this.getItem().finishUsingItem(this, world, entityliving);
    }

    public NBTBase save(HolderLookup.a holderlookup_a, NBTBase nbtbase) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encode((Object)this, holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)nbtbase).getOrThrow();
    }

    public NBTBase save(HolderLookup.a holderlookup_a) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return (NBTBase)CODEC.encodeStart(holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this).getOrThrow();
    }

    public NBTBase saveOptional(HolderLookup.a holderlookup_a) {
        return this.isEmpty() ? new NBTTagCompound() : this.save(holderlookup_a, new NBTTagCompound());
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return MathHelper.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int i2) {
        this.set(DataComponents.DAMAGE, MathHelper.clamp(i2, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public void hurtAndBreak(int i2, WorldServer worldserver, @Nullable EntityPlayer entityplayer, Consumer<Item> consumer) {
        if (this.isDamageableItem() && (entityplayer == null || !entityplayer.hasInfiniteMaterials())) {
            if (i2 > 0) {
                i2 = EnchantmentManager.processDurabilityChange(worldserver, this, i2);
                if (entityplayer != null) {
                    PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)entityplayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), i2);
                    event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                    if (i2 != event.getDamage() || event.isCancelled()) {
                        event.getPlayer().updateInventory();
                    }
                    if (event.isCancelled()) {
                        return;
                    }
                    i2 = event.getDamage();
                }
                if (i2 <= 0) {
                    return;
                }
            }
            if (entityplayer != null && i2 != 0) {
                CriterionTriggers.ITEM_DURABILITY_CHANGED.trigger(entityplayer, this, this.getDamageValue() + i2);
            }
            int j2 = this.getDamageValue() + i2;
            this.setDamageValue(j2);
            if (j2 >= this.getMaxDamage()) {
                Item item = this.getItem();
                if (this.count == 1 && entityplayer != null) {
                    CraftEventFactory.callPlayerItemBreakEvent(entityplayer, this);
                }
                this.shrink(1);
                consumer.accept(item);
            }
        }
    }

    public void hurtAndBreak(int i2, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        net.minecraft.world.level.World world = entityliving.level();
        if (world instanceof WorldServer) {
            EntityPlayer entityplayer1;
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = entityliving instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entityliving) : null;
            this.hurtAndBreak(i2, worldserver, entityplayer, item -> entityliving.onEquippedItemBroken((Item)item, enumitemslot));
        }
    }

    public ItemStack hurtAndConvertOnBreak(int i2, IMaterial imaterial, EntityLiving entityliving, EnumItemSlot enumitemslot) {
        this.hurtAndBreak(i2, entityliving, enumitemslot);
        if (this.isEmpty()) {
            ItemStack itemstack = this.transmuteCopyIgnoreEmpty(imaterial, 1);
            if (itemstack.isDamageableItem()) {
                itemstack.setDamageValue(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot slot, ClickAction clickaction, EntityHuman entityhuman) {
        return this.getItem().overrideStackedOnOther(this, slot, clickaction, entityhuman);
    }

    public boolean overrideOtherStackedOnMe(ItemStack itemstack, Slot slot, ClickAction clickaction, EntityHuman entityhuman, SlotAccess slotaccess) {
        return this.getItem().overrideOtherStackedOnMe(this, itemstack, slot, clickaction, entityhuman, slotaccess);
    }

    public boolean hurtEnemy(EntityLiving entityliving, EntityHuman entityhuman) {
        Item item = this.getItem();
        if (item.hurtEnemy(this, entityliving, entityhuman)) {
            entityhuman.awardStat(StatisticList.ITEM_USED.get(item));
            return true;
        }
        return false;
    }

    public void postHurtEnemy(EntityLiving entityliving, EntityHuman entityhuman) {
        this.getItem().postHurtEnemy(this, entityliving, entityhuman);
    }

    public void mineBlock(net.minecraft.world.level.World world, IBlockData iblockdata, BlockPosition blockposition, EntityHuman entityhuman) {
        Item item = this.getItem();
        if (item.mineBlock(this, world, iblockdata, blockposition, entityhuman)) {
            entityhuman.awardStat(StatisticList.ITEM_USED.get(item));
        }
    }

    public boolean isCorrectToolForDrops(IBlockData iblockdata) {
        return this.getItem().isCorrectToolForDrops(this, iblockdata);
    }

    public EnumInteractionResult interactLivingEntity(EntityHuman entityhuman, EntityLiving entityliving, EnumHand enumhand) {
        return this.getItem().interactLivingEntity(this, entityhuman, entityliving, enumhand);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = new ItemStack(this.getItem(), this.count, this.components.copy());
        itemstack.setPopTime(this.getPopTime());
        return itemstack;
    }

    public ItemStack copyWithCount(int i2) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        itemstack.setCount(i2);
        return itemstack;
    }

    public ItemStack transmuteCopy(IMaterial imaterial) {
        return this.transmuteCopy(imaterial, this.getCount());
    }

    public ItemStack transmuteCopy(IMaterial imaterial, int i2) {
        return this.isEmpty() ? EMPTY : this.transmuteCopyIgnoreEmpty(imaterial, i2);
    }

    private ItemStack transmuteCopyIgnoreEmpty(IMaterial imaterial, int i2) {
        return new ItemStack(imaterial.asItem().builtInRegistryHolder(), i2, this.components.asPatch());
    }

    public static boolean matches(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack == itemstack1 ? true : (itemstack.getCount() != itemstack1.getCount() ? false : ItemStack.isSameItemSameComponents(itemstack, itemstack1));
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> list, List<ItemStack> list1) {
        if (list.size() != list1.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (ItemStack.matches(list.get(i2), list1.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.is(itemstack1.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.is(itemstack1.getItem()) ? false : (itemstack.isEmpty() && itemstack1.isEmpty() ? true : Objects.equals(itemstack.components, itemstack1.components));
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String s2) {
        return CODEC.lenientOptionalFieldOf(s2).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int hashItemAndComponents(@Nullable ItemStack itemstack) {
        if (itemstack != null) {
            int i2 = 31 + itemstack.getItem().hashCode();
            return 31 * i2 + itemstack.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> list) {
        int i2 = 0;
        for (ItemStack itemstack : list) {
            i2 = i2 * 31 + ItemStack.hashItemAndComponents(itemstack);
        }
        return i2;
    }

    public String getDescriptionId() {
        return this.getItem().getDescriptionId(this);
    }

    public String toString() {
        int i2 = this.getCount();
        return i2 + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(net.minecraft.world.level.World world, Entity entity, int i2, boolean flag) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (this.getItem() != null) {
            this.getItem().inventoryTick(this, world, entity, i2, flag);
        }
    }

    public void onCraftedBy(net.minecraft.world.level.World world, EntityHuman entityhuman, int i2) {
        entityhuman.awardStat(StatisticList.ITEM_CRAFTED.get(this.getItem()), i2);
        this.getItem().onCraftedBy(this, world, entityhuman);
    }

    public void onCraftedBySystem(net.minecraft.world.level.World world) {
        this.getItem().onCraftedPostProcess(this, world);
    }

    public int getUseDuration(EntityLiving entityliving) {
        return this.getItem().getUseDuration(this, entityliving);
    }

    public EnumAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.getItem().releaseUsing(this, world, entityliving, i2);
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.components.restorePatch(datacomponentpatch);
    }

    @Nullable
    public <T> T set(DataComponentType<? super T> datacomponenttype, @Nullable T t0) {
        return this.components.set(datacomponenttype, t0);
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> datacomponenttype, T t0, U u0, BiFunction<T, U, T> bifunction) {
        return this.set(datacomponenttype, bifunction.apply(this.getOrDefault(datacomponenttype, t0), u0));
    }

    @Nullable
    public <T> T update(DataComponentType<T> datacomponenttype, T t0, UnaryOperator<T> unaryoperator) {
        T t1 = this.getOrDefault(datacomponenttype, t0);
        return this.set(datacomponenttype, unaryoperator.apply(t1));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> datacomponenttype) {
        return this.components.remove(datacomponenttype);
    }

    public void applyComponentsAndValidate(DataComponentPatch datacomponentpatch) {
        DataComponentPatch datacomponentpatch1 = this.components.asPatch();
        this.components.applyPatch(datacomponentpatch);
        Optional optional = ItemStack.validateStrict(this).error();
        if (optional.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)datacomponentpatch, (Object)((DataResult.Error)optional.get()).message());
            this.components.restorePatch(datacomponentpatch1);
        } else {
            this.getItem().verifyComponentsAfterLoad(this);
        }
    }

    public void applyComponents(DataComponentPatch datacomponentpatch) {
        this.components.applyPatch(datacomponentpatch);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap datacomponentmap) {
        this.components.setAll(datacomponentmap);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public IChatBaseComponent getHoverName() {
        IChatBaseComponent ichatbasecomponent = this.get(DataComponents.CUSTOM_NAME);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        IChatBaseComponent ichatbasecomponent1 = this.get(DataComponents.ITEM_NAME);
        return ichatbasecomponent1 != null ? ichatbasecomponent1 : this.getItem().getName(this);
    }

    private <T extends TooltipProvider> void addToTooltip(DataComponentType<T> datacomponenttype, Item.b item_b, Consumer<IChatBaseComponent> consumer, TooltipFlag tooltipflag) {
        TooltipProvider t0 = (TooltipProvider)this.get(datacomponenttype);
        if (t0 != null) {
            t0.addToTooltip(item_b, consumer, tooltipflag);
        }
    }

    public List<IChatBaseComponent> getTooltipLines(Item.b item_b, @Nullable EntityHuman entityhuman, TooltipFlag tooltipflag) {
        AdventureModePredicate adventuremodepredicate1;
        MapId mapid;
        if (!tooltipflag.isCreative() && this.has(DataComponents.HIDE_TOOLTIP)) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(EnumChatFormat.ITALIC);
        }
        list.add(ichatmutablecomponent);
        if (!tooltipflag.isAdvanced() && !this.has(DataComponents.CUSTOM_NAME) && this.is(Items.FILLED_MAP) && (mapid = this.get(DataComponents.MAP_ID)) != null) {
            list.add(ItemWorldMap.getTooltipForId(mapid));
        }
        Objects.requireNonNull(list);
        Consumer<IChatBaseComponent> consumer = list::add;
        if (!this.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            this.getItem().appendHoverText(this, item_b, list, tooltipflag);
        }
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, item_b, consumer, tooltipflag);
        this.addToTooltip(DataComponents.TRIM, item_b, consumer, tooltipflag);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, item_b, consumer, tooltipflag);
        this.addToTooltip(DataComponents.ENCHANTMENTS, item_b, consumer, tooltipflag);
        this.addToTooltip(DataComponents.DYED_COLOR, item_b, consumer, tooltipflag);
        this.addToTooltip(DataComponents.LORE, item_b, consumer, tooltipflag);
        this.addAttributeTooltips(consumer, entityhuman);
        this.addToTooltip(DataComponents.UNBREAKABLE, item_b, consumer, tooltipflag);
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_BREAK);
        if (adventuremodepredicate != null && adventuremodepredicate.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            adventuremodepredicate.addToTooltip(consumer);
        }
        if ((adventuremodepredicate1 = this.get(DataComponents.CAN_PLACE_ON)) != null && adventuremodepredicate1.showInTooltip()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            adventuremodepredicate1.addToTooltip(consumer);
        }
        if (tooltipflag.isAdvanced()) {
            if (this.isDamaged()) {
                list.add(IChatBaseComponent.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            list.add(IChatBaseComponent.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(EnumChatFormat.DARK_GRAY));
            int i2 = this.components.size();
            if (i2 > 0) {
                list.add(IChatBaseComponent.translatable("item.components", i2).withStyle(EnumChatFormat.DARK_GRAY));
            }
        }
        if (entityhuman != null && !this.getItem().isEnabled(entityhuman.level().enabledFeatures())) {
            list.add(DISABLED_ITEM_TOOLTIP);
        }
        return list;
    }

    private void addAttributeTooltips(Consumer<IChatBaseComponent> consumer, @Nullable EntityHuman entityhuman) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (itemattributemodifiers.showInTooltip()) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.forEachModifier(equipmentslotgroup, (Holder<AttributeBase> holder, AttributeModifier attributemodifier) -> {
                    if (mutableboolean.isTrue()) {
                        consumer.accept(CommonComponents.EMPTY);
                        consumer.accept(IChatBaseComponent.translatable("item.modifiers." + equipmentslotgroup.getSerializedName()).withStyle(EnumChatFormat.GRAY));
                        mutableboolean.setFalse();
                    }
                    this.addModifierTooltip(consumer, entityhuman, (Holder<AttributeBase>)holder, (AttributeModifier)attributemodifier);
                });
            }
        }
    }

    private void addModifierTooltip(Consumer<IChatBaseComponent> consumer, @Nullable EntityHuman entityhuman, Holder<AttributeBase> holder, AttributeModifier attributemodifier) {
        double d0 = attributemodifier.amount();
        boolean flag = false;
        if (entityhuman != null) {
            if (attributemodifier.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                d0 += entityhuman.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
                flag = true;
            } else if (attributemodifier.is(Item.BASE_ATTACK_SPEED_ID)) {
                d0 += entityhuman.getAttributeBaseValue(GenericAttributes.ATTACK_SPEED);
                flag = true;
            }
        }
        double d1 = attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? (holder.is(GenericAttributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (flag) {
            consumer.accept(CommonComponents.space().append(IChatBaseComponent.translatable("attribute.modifier.equals." + attributemodifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), IChatBaseComponent.translatable(holder.value().getDescriptionId()))).withStyle(EnumChatFormat.DARK_GREEN));
        } else if (d0 > 0.0) {
            consumer.accept(IChatBaseComponent.translatable("attribute.modifier.plus." + attributemodifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), IChatBaseComponent.translatable(holder.value().getDescriptionId())).withStyle(holder.value().getStyle(true)));
        } else if (d0 < 0.0) {
            consumer.accept(IChatBaseComponent.translatable("attribute.modifier.take." + attributemodifier.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), IChatBaseComponent.translatable(holder.value().getDescriptionId())).withStyle(holder.value().getStyle(false)));
        }
    }

    public boolean hasFoil() {
        Boolean obool = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return obool != null ? obool.booleanValue() : this.getItem().isFoil(this);
    }

    public EnumItemRarity getRarity() {
        EnumItemRarity enumitemrarity = this.getOrDefault(DataComponents.RARITY, EnumItemRarity.COMMON);
        if (!this.isEnchanted()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case EnumItemRarity.COMMON, EnumItemRarity.UNCOMMON -> EnumItemRarity.RARE;
            case EnumItemRarity.RARE -> EnumItemRarity.EPIC;
            default -> enumitemrarity;
        };
    }

    public boolean isEnchantable() {
        if (!this.getItem().isEnchantable(this)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.get(DataComponents.ENCHANTMENTS);
        return itemenchantments != null && itemenchantments.isEmpty();
    }

    public void enchant(Holder<Enchantment> holder, int i2) {
        EnchantmentManager.updateEnchantments(this, itemenchantments_a -> itemenchantments_a.upgrade(holder, i2));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof EntityItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity entity) {
        if (!this.isEmpty()) {
            this.entityRepresentation = entity;
        }
    }

    @Nullable
    public EntityItemFrame getFrame() {
        return this.entityRepresentation instanceof EntityItemFrame ? (EntityItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup equipmentslotgroup, BiConsumer<Holder<AttributeBase>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(equipmentslotgroup, biconsumer);
        } else {
            this.getItem().getDefaultAttributeModifiers().forEach(equipmentslotgroup, biconsumer);
        }
        EnchantmentManager.forEachModifier(this, equipmentslotgroup, biconsumer);
    }

    public void forEachModifier(EnumItemSlot enumitemslot, BiConsumer<Holder<AttributeBase>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(enumitemslot, biconsumer);
        } else {
            this.getItem().getDefaultAttributeModifiers().forEach(enumitemslot, biconsumer);
        }
        EnchantmentManager.forEachModifier(this, enumitemslot, biconsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.item = item;
    }

    public IChatBaseComponent getDisplayName() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(EnumChatFormat.ITALIC);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.wrapInSquareBrackets(ichatmutablecomponent);
        if (!this.isEmpty()) {
            ichatmutablecomponent1.withStyle(this.getRarity().color()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ITEM, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean canPlaceOnBlockInAdventureMode(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_PLACE_ON);
        return adventuremodepredicate != null && adventuremodepredicate.test(shapedetectorblock);
    }

    public boolean canBreakBlockInAdventureMode(ShapeDetectorBlock shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_BREAK);
        return adventuremodepredicate != null && adventuremodepredicate.test(shapedetectorblock);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int i2) {
        this.popTime = i2;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int i2) {
        this.count = i2;
    }

    public void limitSize(int i2) {
        if (!this.isEmpty() && this.getCount() > i2) {
            this.setCount(i2);
        }
    }

    public void grow(int i2) {
        this.setCount(this.getCount() + i2);
    }

    public void shrink(int i2) {
        this.grow(-i2);
    }

    public void consume(int i2, @Nullable EntityLiving entityliving) {
        if (!(entityliving != null && entityliving.hasInfiniteMaterials() || this == EMPTY)) {
            this.shrink(i2);
        }
    }

    public ItemStack consumeAndReturn(int i2, @Nullable EntityLiving entityliving) {
        ItemStack itemstack = this.copyWithCount(i2);
        this.consume(i2, entityliving);
        return itemstack;
    }

    public void onUseTick(net.minecraft.world.level.World world, EntityLiving entityliving, int i2) {
        this.getItem().onUseTick(world, entityliving, this, i2);
    }

    public void onDestroyed(EntityItem entityitem) {
        this.getItem().onDestroyed(entityitem);
    }

    public SoundEffect getDrinkingSound() {
        return this.getItem().getDrinkingSound();
    }

    public SoundEffect getEatingSound() {
        return this.getItem().getEatingSound();
    }

    public SoundEffect getBreakingSound() {
        return this.getItem().getBreakingSound();
    }

    public boolean canBeHurtBy(DamageSource damagesource) {
        return !this.has(DataComponents.FIRE_RESISTANT) || !damagesource.is(DamageTypeTags.IS_FIRE);
    }
}

