/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.World;

public class ItemSuspiciousStew
extends Item {
    public static final int DEFAULT_DURATION = 160;

    public ItemSuspiciousStew(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public void appendHoverText(ItemStack itemstack, Item.b item_b, List<IChatBaseComponent> list, TooltipFlag tooltipflag) {
        super.appendHoverText(itemstack, item_b, list, tooltipflag);
        if (tooltipflag.isCreative()) {
            ArrayList<MobEffect> list1 = new ArrayList<MobEffect>();
            SuspiciousStewEffects suspicioussteweffects = itemstack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
            for (SuspiciousStewEffects.a suspicioussteweffects_a : suspicioussteweffects.effects()) {
                list1.add(suspicioussteweffects_a.createEffectInstance());
            }
            Objects.requireNonNull(list);
            PotionContents.addPotionTooltip(list1, list::add, 1.0f, item_b.tickRate());
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack itemstack, World world, EntityLiving entityliving) {
        SuspiciousStewEffects suspicioussteweffects = itemstack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
        for (SuspiciousStewEffects.a suspicioussteweffects_a : suspicioussteweffects.effects()) {
            entityliving.addEffect(suspicioussteweffects_a.createEffectInstance());
        }
        return super.finishUsingItem(itemstack, world, entityliving);
    }

    public void cancelUsingItem(EntityPlayer entityplayer, ItemStack itemstack) {
        SuspiciousStewEffects suspicioussteweffects = itemstack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, SuspiciousStewEffects.EMPTY);
        for (SuspiciousStewEffects.a suspicioussteweffects_a : suspicioussteweffects.effects()) {
            entityplayer.connection.send(new PacketPlayOutRemoveEntityEffect(entityplayer.getId(), suspicioussteweffects_a.effect()));
        }
        entityplayer.server.getPlayerList().sendActivePlayerEffects(entityplayer);
    }
}

