/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class ItemTrident
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public ItemTrident(Item.Info item_info) {
        super(item_info);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(GenericAttributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(GenericAttributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
        return !entityhuman.isCreative();
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack itemstack) {
        return EnumAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack itemstack, EntityLiving entityliving) {
        return 72000;
    }

    @Override
    public void releaseUsing(ItemStack itemstack, World world, EntityLiving entityliving, int i2) {
        if (entityliving instanceof EntityHuman) {
            float f2;
            EntityHuman entityhuman = (EntityHuman)entityliving;
            int j2 = this.getUseDuration(itemstack, entityliving) - i2;
            if (j2 >= 10 && ((f2 = EnchantmentManager.getTridentSpinAttackStrength(itemstack, entityhuman)) <= 0.0f || entityhuman.isInWaterOrRain()) && !ItemTrident.isTooDamagedToUse(itemstack)) {
                Holder<SoundEffect> holder = EnchantmentManager.pickHighestLevel(itemstack, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEffects.TRIDENT_THROW);
                if (!world.isClientSide) {
                    if (f2 == 0.0f) {
                        EntityThrownTrident entitythrowntrident = new EntityThrownTrident(world, entityhuman, itemstack);
                        entitythrowntrident.shootFromRotation(entityhuman, entityhuman.getXRot(), entityhuman.getYRot(), 0.0f, 2.5f, 1.0f);
                        if (entityhuman.hasInfiniteMaterials()) {
                            entitythrowntrident.pickup = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        if (!world.addFreshEntity(entitythrowntrident)) {
                            if (entityhuman instanceof EntityPlayer) {
                                ((EntityPlayer)entityhuman).getBukkitEntity().updateInventory();
                            }
                            return;
                        }
                        itemstack.hurtAndBreak(1, entityhuman, EntityLiving.getSlotForHand(entityliving.getUsedItemHand()));
                        entitythrowntrident.pickupItemStack = itemstack.copy();
                        world.playSound((EntityHuman)null, entitythrowntrident, holder.value(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (!entityhuman.hasInfiniteMaterials()) {
                            entityhuman.getInventory().removeItem(itemstack);
                        }
                    } else {
                        itemstack.hurtAndBreak(1, entityhuman, EntityLiving.getSlotForHand(entityliving.getUsedItemHand()));
                    }
                }
                entityhuman.awardStat(StatisticList.ITEM_USED.get(this));
                if (f2 > 0.0f) {
                    float f1 = entityhuman.getYRot();
                    float f22 = entityhuman.getXRot();
                    float f3 = -MathHelper.sin(f1 * ((float)Math.PI / 180)) * MathHelper.cos(f22 * ((float)Math.PI / 180));
                    float f4 = -MathHelper.sin(f22 * ((float)Math.PI / 180));
                    float f5 = MathHelper.cos(f1 * ((float)Math.PI / 180)) * MathHelper.cos(f22 * ((float)Math.PI / 180));
                    float f6 = MathHelper.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
                    CraftEventFactory.callPlayerRiptideEvent(entityhuman, itemstack, f3 *= f2 / f6, f4 *= f2 / f6, f5 *= f2 / f6);
                    entityhuman.push(f3, f4, f5);
                    entityhuman.startAutoSpinAttack(20, 8.0f, itemstack);
                    if (entityhuman.onGround()) {
                        float f7 = 1.1999999f;
                        entityhuman.move(EnumMoveType.SELF, new Vec3D(0.0, 1.1999999284744263, 0.0));
                    }
                    world.playSound((EntityHuman)null, entityhuman, holder.value(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World world, EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (ItemTrident.isTooDamagedToUse(itemstack)) {
            return InteractionResultWrapper.fail(itemstack);
        }
        if (EnchantmentManager.getTridentSpinAttackStrength(itemstack, entityhuman) > 0.0f && !entityhuman.isInWaterOrRain()) {
            return InteractionResultWrapper.fail(itemstack);
        }
        entityhuman.startUsingItem(enumhand);
        return InteractionResultWrapper.consume(itemstack);
    }

    private static boolean isTooDamagedToUse(ItemStack itemstack) {
        return itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1;
    }

    @Override
    public boolean hurtEnemy(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.hurtAndBreak(1, entityliving1, EnumItemSlot.MAINHAND);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public IProjectile asProjectile(World world, IPosition iposition, ItemStack itemstack, EnumDirection enumdirection) {
        EntityThrownTrident entitythrowntrident = new EntityThrownTrident(world, iposition.x(), iposition.y(), iposition.z(), itemstack.copyWithCount(1));
        entitythrowntrident.pickup = EntityArrow.PickupStatus.ALLOWED;
        return entitythrowntrident;
    }
}

