/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.a registries;
    public Multimap<Recipes<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    private Map<MinecraftKey, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public CraftingManager(HolderLookup.a holderlookup_a) {
        super(GSON, Registries.elementsDirPath(Registries.RECIPE));
        this.registries = holderlookup_a;
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> map, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        RegistryOps registryops = this.registries.createSerializationContext(JsonOps.INSTANCE);
        for (Map.Entry<MinecraftKey, JsonElement> entry : map.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                IRecipe irecipe = (IRecipe)IRecipe.CODEC.parse(registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<IRecipe> recipeholder = new RecipeHolder<IRecipe>(minecraftkey, irecipe);
                builder.put(irecipe.getType(), recipeholder);
                com_google_common_collect_immutablemap_builder.put((Object)minecraftkey, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.byType = LinkedHashMultimap.create((Multimap)builder.build());
        this.byName = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Collection map = this.byType.get(irecipe.value().getType());
        if (this.byName.containsKey(irecipe.id())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.id()));
        }
        map.add(irecipe);
        this.byName.put(irecipe.id(), irecipe);
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> recipes, I i0, World world) {
        return this.getRecipeFor(recipes, i0, world, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> recipes, I i0, World world, @Nullable MinecraftKey minecraftkey) {
        RecipeHolder<T> recipeholder = minecraftkey != null ? this.byKeyTyped(recipes, minecraftkey) : null;
        return this.getRecipeFor(recipes, i0, world, recipeholder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> getRecipeFor(Recipes<T> recipes, I i0, World world, @Nullable RecipeHolder<T> recipeholder) {
        List<RecipeHolder> list = this.byType(recipes).stream().filter(recipeholder1 -> recipeholder1.value().matches((RecipeInput)i0, world)).toList();
        Optional<RecipeHolder<T>> recipe = list.isEmpty() || i0.isEmpty() ? Optional.empty() : (recipeholder != null && recipeholder.value().matches(i0, world) ? Optional.of(recipeholder) : Optional.of(list.getLast()));
        return recipe;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> getAllRecipesFor(Recipes<T> recipes) {
        return List.copyOf(this.byType(recipes));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> getRecipesFor(Recipes<T> recipes, I i0, World world) {
        return this.byType(recipes).stream().filter(recipeholder -> recipeholder.value().matches((RecipeInput)i0, world)).sorted(Comparator.comparing(recipeholder -> recipeholder.value().getResultItem(world.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> byType(Recipes<T> recipes) {
        return this.byType.get(recipes);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> recipes, I i0, World world) {
        Optional<RecipeHolder<T>> optional = this.getRecipeFor(recipes, i0, world);
        if (optional.isPresent()) {
            return optional.get().value().getRemainingItems(i0);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(i0.size(), ItemStack.EMPTY);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, i0.getItem(i2));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> byKey(MinecraftKey minecraftkey) {
        return Optional.ofNullable(this.byName.get(minecraftkey));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> byKeyTyped(Recipes<T> recipes, MinecraftKey minecraftkey) {
        RecipeHolder<?> recipeholder = this.byName.get(minecraftkey);
        return recipeholder != null && recipeholder.value().getType().equals(recipes) ? recipeholder : null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<MinecraftKey> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(MinecraftKey minecraftkey, JsonObject jsonobject, HolderLookup.a holderlookup_a) {
        IRecipe irecipe = (IRecipe)IRecipe.CODEC.parse(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)jsonobject).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(minecraftkey, irecipe);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> iterable) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : iterable) {
            Recipes<?> recipes = recipeholder.value().getType();
            builder.put(recipes, recipeholder);
            com_google_common_collect_immutablemap_builder.put((Object)recipeholder.id(), recipeholder);
        }
        this.byType = LinkedHashMultimap.create((Multimap)builder.build());
        this.byName = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        Iterator iter = this.byType.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.id().equals(mcKey)) continue;
            iter.remove();
        }
        return this.byName.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.byType = LinkedHashMultimap.create();
        this.byName = Maps.newHashMap();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> createCheck(final Recipes<T> recipes) {
        return new a<I, T>(){
            @Nullable
            private MinecraftKey lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I i0, World world) {
                CraftingManager craftingmanager = world.getRecipeManager();
                Optional optional = craftingmanager.getRecipeFor(recipes, i0, world, this.lastRecipe);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.lastRecipe = recipeholder.id();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, World var2);
    }
}

