/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;

public interface IRecipe<T extends RecipeInput> {
    public static final Codec<IRecipe<?>> CODEC = BuiltInRegistries.RECIPE_SERIALIZER.byNameCodec().dispatch(IRecipe::getSerializer, RecipeSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IRecipe<?>> STREAM_CODEC = ByteBufCodecs.registry(Registries.RECIPE_SERIALIZER).dispatch(IRecipe::getSerializer, RecipeSerializer::streamCodec);

    public boolean matches(T var1, World var2);

    public ItemStack assemble(T var1, HolderLookup.a var2);

    public boolean canCraftInDimensions(int var1, int var2);

    public ItemStack getResultItem(HolderLookup.a var1);

    default public NonNullList<ItemStack> getRemainingItems(T t0) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(t0.size(), ItemStack.EMPTY);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            Item item = t0.getItem(i2).getItem();
            if (!item.hasCraftingRemainingItem()) continue;
            nonnulllist.set(i2, new ItemStack(item.getCraftingRemainingItem()));
        }
        return nonnulllist;
    }

    default public NonNullList<RecipeItemStack> getIngredients() {
        return NonNullList.create();
    }

    default public boolean isSpecial() {
        return false;
    }

    default public boolean showNotification() {
        return true;
    }

    default public String getGroup() {
        return "";
    }

    default public ItemStack getToastSymbol() {
        return new ItemStack(Blocks.CRAFTING_TABLE);
    }

    public RecipeSerializer<?> getSerializer();

    public Recipes<?> getType();

    default public boolean isIncomplete() {
        NonNullList<RecipeItemStack> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().anyMatch(recipeitemstack -> recipeitemstack.getItems().length == 0);
    }

    public Recipe toBukkitRecipe(NamespacedKey var1);
}

